<?php
/**
 ** CNZZ广告管家业务服务
 ** @createtime 2013-05-06 by xstar@cnzz.com
 **/

! defined ( 'CNZZADM' ) && exit ( 'Forbidden' );

class Cnzzadm_Common_General_Service{
    /**
     *获得广告位内容
     *@param $pid 位置
     *@return string
     */
    function getSlotData($pid ,$floor='-1'){
        global          $_G;
        if($_G['basescript']!='forum' && $_G['basescript']!='portal'){
            return '';
        }
        $admDB          =      Cnzzadm_Common_Data_Service::getstance();
        $infoData       =      $admDB -> getIdInfo();
        $fid            =      Cnzzadm_Common_General_Service::getViewFid(); 
        $floorid        =      $floor; //当前楼层
        $date           =      date('Y-m-d-H:i');//当前时间
        $slotcontent    =      array();
        
        foreach($infoData as $k => $v){
            if($v['pid'] ==  $pid){
                $deliveryinfo    =     $v['delivery'];
                $deliverystate   =     false;
                foreach($deliveryinfo as $dk => $dv){ 
                    if(!Cnzzadm_Common_General_Service::isShowByFid($fid,$dv['fid']))
                        continue;
                    if(!Cnzzadm_Common_General_Service::isShowByDate($date,$dv['time']))
                        continue;
                    if(!Cnzzadm_Common_General_Service::isShowByFloorid($floorid,$dv['floorid']))
                        continue;
                    $deliverystate =  true;
                    break;  
                }
                if($deliverystate){
                    $slotid     =   $v['id'];
                    $width      =   $v['width'];
                    $height     =   $v['height'];
                    if($floorid == '-1') $floorid = '';
                    if($pid>=7&&$pid<=9){
                        $script        =        Cnzzadm_Common_General_Service::getConfig( 'common.floor.request' );
                        array_push($slotcontent,str_replace(array('<<cnzzadm_floor_js>>','<<slotid>>','<<floorid>>'),array(CNZZADM_FLOOR_JS,$slotid,$floorid),$script));
                    }else{
                        $script        =        Cnzzadm_Common_General_Service::getConfig( 'common.scriptnew.request' );
                        array_push($slotcontent,str_replace('<<slotid>>',$slotid,$script)); 
                    }
                }
                
            }
        }
        return $slotcontent;
    }
    /**
     *获得pid 页面类型信息
     *@return string
     */

    function getModule(){

        global $_G;
        $basescript    =   $_G['basescript'];
        if($basescript ==  'forum'){
            if(CURMODULE =='index'){
                return 'bbs.index';
            }
            if(CURMODULE == 'viewthread'){
                return 'bbs.read';
            }
            if(CURMODULE == 'forumdisplay'){
                return 'bbs.thread';
            }
        } 
        elseif($basescript == 'portal'){
            if(CURMODULE == 'index')
                return 'portal.index';
            else if(CURMODULE == 'list')
                return 'portal.list';
            else if(CURMODULE == 'view')
                return 'portal.view';  
        }
    }

    /**
     *获得fid信息
     *@return string
     */
    function getViewFid(){
        global $_G;
        if($_G['basescript'] == 'forum'){
            $fid        =      $_G['action']['fid'];//当前板块信息
            if(!$fid){
                $fid    =      Cnzzadm_Common_General_Service::getModule();
            }
        }elseif($_G['basescript'] == 'portal'){
            $fid        =      $_G['catid']; 
            if($fid){
                $fid    =      'm_'.$fid;
            }else{
                $fid    =      Cnzzadm_Common_General_Service::getModule();
            }
        }
        return $fid;
    }

    /**
     *页面类型删选
     *@param $midinfo  展现页面
     *@return bool 
     */
    function isShowByModule($midinfo){
        if(CURMODULE =='index'){
            if($midinfo){
                return true;
            }
            return false; 
        }
        return true;
    }

    /**
     *日期删选
     *@param $date 日期参数  $dateinfo 展现日期
     *@return bool
     */
    function isShowByDate($date,$dateinfo){
        $dateinfoarray    =     explode(',',$dateinfo);
        if($date>=$dateinfoarray[0]&&$date<=$dateinfoarray[1]){
            return true; 
        }
        return false; 
    }
   
    /**
     *板块删选
     *@param $fid 板块参数  $fidinfo 展现板块
     *@return bool
     */
    function isShowByFid($fid,$fidinfo){
        if(empty($fidinfo) || in_array($fid,explode(',',$fidinfo))){
            return true; 
        }
        return false;
    }

    /**
     *楼层删选
     *@param floorid 楼层参数 $floorinfo 展现楼层
     *@return bool
     */
    function isShowByFloorid($floorid,$floorinfo){
        if(CURMODULE == 'viewthread'){
            if(empty($floorinfo)  || in_array($floorid,explode(',',$floorinfo))|| $floorid == -1 ){
                return true;
            } 
            return false;
        }
        return true;
    }
	
	/**
	*获取模版内容
	*@return string
    *@params $confiName 模版名称
    */
    function getConfig($configName) {
        $configName = strtolower ( $configName );
        if (str_replace ( array ('://', "\0", '..' ), '', $configName ) != $configName)
            return false;
        $filePath = CNZZADM . '/config/' . $configName . '.php';
        if (! file_exists ( $filePath ))
            return false;
        return include $filePath;
    }
    
    /**
     *返回页面组装内容
     *@param $slotcontent 广告位内容 $adcontent 原有广告位内容
     *@return sting
     */
    function returnFixedData($slotcontent,$adcontent){
        if(count($slotcontent)>0&& is_array($slotcontent)){
            $slotstr             =           '';
            foreach($slotcontent as $v){
                $slotstr        .=   '<div class = "'.$adcontent['params'][1].'">'.$v.'  </div>'; 
				//$slotstr        .=   '<div class = "'.$adcontent['params'][1].'">'.$v.'  </div>'; 
            }
            return ($slotstr.$adcontent['content']);
        }
        return $adcontent['content']; 
    }
    
    /**
     *返回头部通用js
     *@return string
     */
    function getGlobalHeader(){
        $fid        =       Cnzzadm_Common_General_Service::getViewFid(); 
        $header     =       Cnzzadm_Common_General_Service::getConfig('common.header.request');
        $header     =       str_replace(array('<<cnzzadm_common_js>>','<<cnzzadm_fid>>'),array(CNZZADM_COMMON_JS,$fid),$header);
        return      $header;
    }
}
?>
