@echo off

if (%1) == () goto InvalidFile

echo Replacing %1 using CopyLock

rem optionally adds:
rem  /downgrade to accept downgrade while replacing a file
rem  /reboot to automatically reboot if needed to complete the replacement

copylock.exe %1 %2

if errorlevel 5 goto Pending
if errorlevel 4 goto Deleted
if errorlevel 3 goto Replaced
if errorlevel 2 goto DowngradeError
if errorlevel 1 goto GeneralError
if errorlevel 0 goto NotProcessed

echo Unknown error
goto end

:InvalidFile
echo Invalid file name
goto end

:NotProcessed
echo File not processed
goto end

:GeneralError
echo An error occured or file not found
goto end

:DowngradeError
echo Downgrade not allowed
goto end

:Replaced
echo The file was successfully replaced
goto end

:Deleted
echo The file was successfully deleted
goto end

:Pending
echo The file is queued for replacement on next reboot

:end
