<?php

    /***************************************************************\
    |                                                               |
    |   彩纸屋（彩纸屋编程系统）                                    |
    |                                                               |
    |   © 2019-2023 淮南市银泰软件科技有限公司 All rights reserved  |
    |                                                               |
    |   https://www.kidssteam.cn/                                   |
    |                                                               |
    |   QQ号：984784483                                             |
    |                                                               |
    \***************************************************************/

    namespace app\api\controller\v1\student;
    use app\common\controller\RestUserBaseController;
    use app\user\service\IndexUserService;
    use app\common\lib\Upload;
    use think\Db;
    class AccountController extends RestUserBaseController {

    	// 获取登录用户信息
        public function getUserInfo() {
        	$userInfo = $this->user;
            $userInfo['role']['permissions'][] = ['permissionId'=>'dashboard'];
            $userInfo['role']['permissions'][] = ['permissionId'=>'user'];
    		$this->success('',$userInfo);
        }

        //修改登录用户的个人基本信息
        public function updateUser() {
            $param = $this->request->param();
            $IndexUserService = new IndexUserService();
            $res = $IndexUserService->updateMyUser($param);
            if ($res) {
                $this->success('保存成功！');
            } else {
                $this->error('保存失败！');
            }
        }

        /**
         * upload 上传
         */
        public function uploadAvatar() {
            if ($this->request->isPost()) {
                $id = input('id');
                $uploader = new Upload();
                $result = $uploader->upload();
                if ($result === false) {
                    $this->error($uploader->getError());
                } else {
                    $result['filepath'] = getAssetUrl($result['filepath']);
                    Db::name('user')->where('id',$id)->update(['avatar'=>$result['url']]);
                    $this->success("上传成功!", $result);
                }
            }
        }

        //修改用户密码jfour
        public function updatePassword() {
            $param = $this->request->param();
            $IndexUserService = new IndexUserService();
            $res = $IndexUserService->updateMyPassword($param);
            if ($res) {
                $this->success('修改成功！');
            } else {
                $this->error('修改失败！');
            }
        }

    }