<?php

/***************************************************************\
|                                                               |
|   彩纸屋（彩纸屋编程系统）                                    |
|                                                               |
|   © 2019-2023 淮南市银泰软件科技有限公司 All rights reserved  |
|                                                               |
|   https://www.kidssteam.cn/                                   |
|                                                               |
|   QQ号：984784483                                             |
|                                                               |
\***************************************************************/

namespace app\course\service;

use app\common\service\BaseService;

use think\facade\Validate;
use think\db\Where;

use app\course\model\ScratchCourseModel;
use app\course\model\ScratchLectureModel;
use app\course\model\ScratchStudentCourseModel;
use app\course\model\ScratchHomeworkModel;
use app\scratch\model\ScratchWorksModel;
use app\python\model\PythonWorksModel;




class IndexCourseService extends BaseService
{


    /**
     * 查询
     * @param      $filter
     * @return \think\Paginator
     * @throws \think\exception\DbException
     */
    public function getCourseList($filter = array())
    {


        $where  = new Where;
  

        if (!empty($filter['search'])) {
            $where['course_name'] = $filter['search'];
        }

        if (!empty($filter['course_status']) && $filter['course_status'] != 0) {
            $where['course_status'] = $filter['course_status'];
        }


        $field = '*';

        $ScratchStudentCourseModel = new ScratchStudentCourseModel();
        $ScratchCourseModel = new ScratchCourseModel();

        $courseIds = $ScratchStudentCourseModel
                ->where('student_id',getStudentId())
                ->column('course_id');

        $where['parent_id'] = 0;
        $where['id'] = ['in',$courseIds];

        // 查询课程列表
        $course      = $ScratchCourseModel
            ->where($where)
            ->order('list_order asc')
            ->field($field)
            ->select()
            ->append(['status_text','course_status_text'])
            ->toArray();




        return $course;

    }


    public function getCourseById($filter = array())
    {
        $ScratchCourseModel = new ScratchCourseModel();

        $id      = isset($filter['id']) ? $filter['id'] : 0;

        $CourseFind = $ScratchCourseModel
                ->append(['status_text','course_status_text','course_mode_text'])
                ->find($id);

        

        return $CourseFind;
    }

    public function getLectureListByCourseId($filter = array())
    {
        $where = [];
  

        if (!empty($filter['course_id']) && $filter['course_id'] != 0) {
            if (is_array($filter['course_id'])) {
                $where = [['course_id','in',$filter['course_id']]];
            } else {
                $where['course_id'] = $filter['course_id'];
            }
            
        }



        $field = '*';


        $ScratchLectureModel = new ScratchLectureModel();
        $ScratchHomeworkModel = new ScratchHomeworkModel();

        // 查询课时列表
        $LectureSelect      = $ScratchLectureModel
            ->where($where)
            ->field($field)
            ->append(['status_text','lecture_status_text'])
            ->order('list_order asc')
            ->select()
            ->toArray();

        $data = $LectureSelect;
        $ids = [];
        $categoryIds = [];
        foreach ($data as $key => $value) {
            $ids[] = $value['id'];
        }


        $homeworkSelect      = $ScratchHomeworkModel
            ->where('lecture_id','in',$ids)
            ->where('create_user_id',getUserId())
            ->field($field)
            ->append(['status_text'])
            ->select()
            ->toArray();




        // 数据组装
        foreach ($data as $key => $value) {
            $data[$key]['homework'] = [];
            $data[$key]['homework_status'] = 0;
            foreach ($homeworkSelect as $k => $v) {
                if ($v['lecture_id'] == $value['id']){
                    $data[$key]['homework'][] = $v;

                    if ($v['homework_status'] == 1) {
                        $data[$key]['homework_status'] = 1;
                    }
                    
                    unset($homeworkSelect[$k]);
                }
            }

        }

        $LectureSelect = $data;


        return $LectureSelect;
    }
    

    public function getLectureById($filter = array())
    {
        $ScratchLectureModel = new ScratchLectureModel();

        $id      = isset($filter['id']) ? $filter['id'] : 0;

        $LectureFind = $ScratchLectureModel
                ->append(['status_text','lecture_status_text'])
                ->find($id);

        

        return $LectureFind;
    }




    public function getHomeworkListByCourseId($filter = array())
    {
        $where = [];
  
        $courseInfo = $this->getCourseById(['id'=>$filter['id']]);


        $courseInfo['lectures'] = [];

        $courseInfo['lectures'] = $this->getLectureListByCourseId(['course_id'=>$courseInfo['id']]);

        return $courseInfo;
    }

}