<?php

/***************************************************************\
|                                                               |
|   彩纸屋（彩纸屋编程系统）                                    |
|                                                               |
|   © 2019-2023 淮南市银泰软件科技有限公司 All rights reserved  |
|                                                               |
|   https://www.kidssteam.cn/                                   |
|                                                               |
|   QQ号：984784483                                             |
|                                                               |
\***************************************************************/

namespace app\python\controller;

use app\common\controller\HomeBaseController;
use think\Db;
use app\org\model\OrgModel;


class IndexController extends HomeBaseController
{
	
	public function index()
	{
		$siteInfo = getOption('site_info','overall');
		$siteInfo['logo'] = '/static/logo-2.png';

        $siteInfo['show_scratch_btn'] = 0;

		$subDomain = $this->request->subDomain();
		
        $param = $this->request->param();
		
		
		
        if($subDomain != config("database.sub_domain")){
            
            $www = explode(".",$subDomain);
            
            $subDomain = $www[0];
            
            $data['subDomain'] = $subDomain;

            $OrgModel = new OrgModel();
            $orgInfo = $OrgModel
                    ->where([
                        'org_domain'       => $subDomain,
                    ])
                    ->find();
            if(empty($orgInfo)){
	            $this->assign('siteInfo',$siteInfo);
	        	return $this->fetch(':index');
            }else{
            	if (isset($orgInfo['org_logo'])) {
					$siteInfo['logo'] = $orgInfo['org_logo'];
            	}
            	
            	if($orgInfo['show_scratch_btn']){
            	    $siteInfo['show_scratch_btn'] = 1;
            	}
            	$siteInfo['orgInfo'] = $orgInfo;
	            $this->assign('siteInfo',$siteInfo);
	            return $this->fetch(':index');
            }


        }else{
            $this->assign('siteInfo',$siteInfo);
        	return $this->fetch(':index');
        }
	}
	
	
	
	public function test1()
	{
		$siteInfo = getOption('site_info','overall');
		$siteInfo['logo'] = '/static/logo-2.png';

        $siteInfo['show_scratch_btn'] = 0;

		$subDomain = $this->request->subDomain();
        if($subDomain != config("database.sub_domain")){
            
            $www = explode(".",$subDomain);
            
            $subDomain = $www[0];
            
            $data['subDomain'] = $subDomain;

            $OrgModel = new OrgModel();
            $orgInfo = $OrgModel
                    ->where([
                        'org_domain'       => $subDomain,
                    ])
                    ->find();
            if(empty($orgInfo)){
	            $this->assign('siteInfo',$siteInfo);
	        	return $this->fetch(':index');
            }else{
            	if (isset($orgInfo['org_logo'])) {
					$siteInfo['logo'] = $orgInfo['org_logo'];
            	}
            	
            	if($orgInfo['show_scratch_btn']){
            	    $siteInfo['show_scratch_btn'] = 1;
            	}
            	$siteInfo['orgInfo'] = $orgInfo;
	            $this->assign('siteInfo',$siteInfo);
	            return $this->fetch(':index');
            }


        }else{
            $this->assign('siteInfo',$siteInfo);
        	return $this->fetch(':test');
        }
	}
	
	
	public function test2()
	{
		return $this->fetch(':embed-blocks-iframe');
	}
	
	public function show()
	{
		return $this->fetch(':show');
	}
	
}

