-- I based this code off of a similar piece written by TheDanaAddams
-- creator of the popular link don't starve character
-- the URL of that Modder is : http://forums.kleientertainment.com/user/267484-thedanaaddams/?tab=idm

-- the "Mow" action, needs to be created to allow "Mow" action in game
GLOBAL.STRINGS.ACTIONS.MOWDOWN = "Mow Down" --Appears in the game.
local ACTIONS = GLOBAL.ACTIONS
ACTIONS.MOWDOWN = GLOBAL.Action(1)
ACTIONS.MOWDOWN.id = "MOWDOWN"
ACTIONS.MOWDOWN.str = GLOBAL.STRINGS.ACTIONS.MOWDOWN
ACTIONS.MOWDOWN.fn = function(act)
if act.target.components.pickable then
	act.target.components.pickable:mowDown(act.doer)
	return true
end
end

-- created new state "mowdown", which basically describes what to do display
-- while mowing grass
local mowAtDown = GLOBAL.State{
name = "mowdown",
tags = {"doing", "busy"},
onenter = function(inst)
inst.components.locomotor:Stop()
inst.AnimState:PlayAnimation("atk")
inst.SoundEmitter:PlaySound("dontstarve/wilson/attack_weapon")
inst.sg:SetTimeout(10*GLOBAL.FRAMES) --Flying into pocket
end,
--6,4,10 - ~default values 0,5-0,6 sec, now 0,7-0,8 sec
timeline=
{
	GLOBAL.TimeEvent(4*GLOBAL.FRAMES, function( inst ) --???
		inst.sg:RemoveStateTag("busy")
		end),
	GLOBAL.TimeEvent(14*GLOBAL.FRAMES, function( inst ) --Go to next object
		inst.sg:RemoveStateTag("doing")
		inst.sg:AddStateTag("idle")
		end),
	},

	ontimeout = function(inst)
	inst:PerformBufferedAction()      
	end,

	events=
	{
	GLOBAL.EventHandler("animover", function(inst) if inst.AnimState:AnimDone() then inst.sg:GoToState("idle") end end ),
	},
}

-- add "mow" state to states graph
AddStategraphPostInit("wilson", function(sg)
	local actionHandler = GLOBAL.ActionHandler(ACTIONS.MOWDOWN, mowAtDown.name)
	sg.actionhandlers[ACTIONS.MOWDOWN] = actionHandler
	sg.states[mowAtDown.name] = mowAtDown
	end)

-- drop item
local function mowDownFn(self,picker)
	if self.canbepicked and self.caninteractwith then
		self:Pick(picker)
	end
end
local function makeMow(prefab)
	prefab:AddTag("mower")
end
AddPrefabPostInit("scythe",makeMow)
--AddPrefabPostInit("spear",makeMow)
-- add "Mow" action to CollectScenceActions
local function replaceCollectAction(inst)
	local standardCollect = inst.CollectSceneActions
		inst.CollectSceneActions = function (self, doer, actions)
		-- get item and check if can mow, if can then do so, otherwise pick
		local item = doer.components.inventory:GetEquippedItem(GLOBAL.EQUIPSLOTS.HANDS)
		if self.caninteractwith and self.canbepicked and item and item:HasTag("mower") then
			table.insert(actions, ACTIONS.MOWDOWN)
		else
			standardCollect(self, doer, actions)
		end
	end
end

-- modify the prefab to include new "Mow" function, a type of picking
local function modifyPrefab(inst)
	local pickFuncs = inst.components.pickable
	pickFuncs.mowDown = mowDownFn
	replaceCollectAction(pickFuncs)
end
AddPrefabPostInit("grass", modifyPrefab)
AddPrefabPostInit("reeds", modifyPrefab)
AddPrefabPostInit("sapling",modifyPrefab)

--add to Action Button Actions as well
local function addActionButtonPostInit(inst)
	inst.standardGetAction = inst.GetActionButtonAction
	function inst:GetActionButtonAction()
		local bact = self:standardGetAction()
		if bact == nil then
			return
		end
		if bact.target.prefab ~= "grass" and bact.target.prefab ~= "reeds" and bact.target.prefab ~= "sapling" then
			return bact
		end
		if bact.doer and bact.target and
			bact.action == ACTIONS.PICK and bact.invobject and bact.invobject:HasTag("mower") then
			bact.action = ACTIONS.MOWDOWN
		end
		return bact
	end
end

AddComponentPostInit("playercontroller", addActionButtonPostInit)

