local assets=
{ 
    Asset("ANIM", "anim/scythe.zip"),
    Asset("ANIM", "anim/swap_scythe.zip"), 

    Asset("ATLAS", "images/inventoryimages/scythe.xml"),
    Asset("IMAGE", "images/inventoryimages/scythe.tex"),
}

local prefabs = 
{
}

local function fn(colour)

    local function OnEquip(inst, owner) 
        --owner.AnimState:OverrideSymbol("swap_object", "swap_scythes", "purplestaff")
        owner.AnimState:OverrideSymbol("swap_object", "swap_scythe", "scythe")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
    end

    local function OnUnequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
    end

    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("scythe")
    anim:SetBuild("scythe")
    anim:PlayAnimation("idle")
	
	--my input
	
	inst:AddTag("sharp")

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(38)
    
    -------
    
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(120)
    inst.components.finiteuses:SetUses(120)
	
	inst.components.finiteuses:SetOnFinished( onfinished )
	
	inst:AddComponent("inspectable")
	
	--------------------------------For add tool function--------------------------------
	inst:AddComponent("tool")
	inst.components.tool:SetAction(ACTIONS.MOWDOWN, 1) --Not exactly sure why, but it is necessary here.
	
	--inst.components.finiteuses:SetMaxUses(TUNING.PICKAXE_USES)
    --inst.components.finiteuses:SetUses(TUNING.PICKAXE_USES)
    inst.components.finiteuses:SetOnFinished( onfinished) 
    inst.components.finiteuses:SetConsumption(ACTIONS.MOWDOWN, 0.48) --Adjust the speed of consumption durability as the tool. Now is 250 uses.
	--------------------------------For add tool function--------------------------------
	
	--end

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "scythe"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/scythe.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )

    return inst
end

----------------------------------------------------------------
return  Prefab("common/inventory/scythe", fn, assets, prefabs)