local MakePlayerCharacter = require "prefabs/player_common"

local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset("ANIM", "anim/bulbman_open.zip"),
        Asset( "ANIM", "anim/bulbman.zip" ),
		
		Asset("SOUND", "sound/pig.fsb"),
}
local prefabs = {}
local start_inv = {
	-- Custom starting items
}

local max_upgrades = 20

local function applyupgrades(inst)

        
        local upgrades = math.min(inst.level, max_upgrades)

        local hunger_percent = inst.components.hunger:GetPercent()
        local health_percent = inst.components.health:GetPercent()
        local sanity_percent = inst.components.sanity:GetPercent()

        inst.components.hunger.max = math.ceil (80 + upgrades * 6)
        inst.components.health.maxhealth = math.ceil (140 + upgrades * 8)
        inst.components.sanity.max = math.ceil (90 + upgrades * 3)
       
        inst.components.combat.damagemultiplier = math.ceil (1 + upgrades / 20)

        local light = inst.entity:AddLight()
     
	    light:Enable(false)
	    light:SetRadius(0.8+upgrades*0.25)
	    light:SetIntensity(0.6+upgrades*0.01)
	    light:SetFalloff(0.5)    -- +( 0.1*upgrades -0.1 ) 
        light:SetColour(237/255, 237/255, 209/255)
		
		

        inst.components.sanity:DoDelta(-10)
        inst.sg:GoToState("electrocute") 
        inst.components.talker:Say("bulb level : ".. (inst.level))
        
        if inst.level >19 then
                inst.components.talker:Say("bulb maximum brightness")
        end

        inst.components.hunger:SetPercent(hunger_percent)
        inst.components.health:SetPercent(health_percent)
        inst.components.sanity:SetPercent(sanity_percent)
end
local function oneat(inst, food)
     local chance1 = 0.4
     local chance2 = 0.2
	 local chance3 = 0.9
	 local chance4 = 0.4
	 local iflevelup = false
	 if math.random() < chance1 and food and food.components.edible and food.components.edible.foodtype == "FIREFLIES" then
            iflevelup = true
			end
	 if math.random() < chance2 and food.prefab == "lightbulb" then
            iflevelup = true
			end
	 if math.random() < chance3 and food.prefab == "wormlight" then
	        iflevelup = true
	        end
	 if math.random() < chance4 and food and food.components.edible and food.components.edible.foodtype == "BIOLUMINESSENCE" then
            iflevelup = true
			end
		 
	
		
		if iflevelup and inst.level < max_upgrades then
		
		inst.level = inst.level + 1
		
		applyupgrades(inst)	
		inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")
		inst.HUD.controls.status.heart:PulseGreen()
		inst.HUD.controls.status.stomach:PulseGreen()
		inst.HUD.controls.status.brain:PulseGreen()
		
		inst.HUD.controls.status.brain:ScaleTo(1.3,1,.7)
		inst.HUD.controls.status.heart:ScaleTo(1.3,1,.7)
		inst.HUD.controls.status.stomach:ScaleTo(1.3,1,.7)
	end

end

local function onpreload(inst, data)
        if data then
                if data.level then
                        inst.level = data.level
                        applyupgrades(inst)
                        --re-set these from the save data, because of load-order clipping issues
                        if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
                        if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
                        if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
                        inst.components.health:DoDelta(0)
                        inst.components.hunger:DoDelta(0)
                        inst.components.sanity:DoDelta(0)
                end
        end

end

local function onsave(inst, data)
        data.level = inst.level
end
local function OnLoad(inst, data)
    if inst.components.machine and inst.components.machine.ison then
       
        turnon(inst)
    else
      
        turnoff(inst)
    end
end


local function onhungerchange(inst, data)
	
	if inst.components.hunger.current<10 and inst.Light:IsEnabled() then
	    inst.Light:Enable(false)
		inst.AnimState:SetBuild("bulbman")		         
		inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE)
		inst.components.talker:Say("I'm so hungry, bulb doesn't work")
	end
end


local fn = function(inst)
	
	-- choose which sounds this character will play
	inst.soundsname = "willow"

	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "bulbman.tex" )
	inst.level = 0
    inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED)
    inst.components.locomotor.runspeed =  (TUNING.WILSON_RUN_SPEED)
    table.insert(inst.components.eater.foodprefs, "FIREFLIES")
	table.insert(inst.components.eater.ablefoods, "FIREFLIES")
	table.insert(inst.components.eater.foodprefs, "BIOLUMINESSENCE")
	table.insert(inst.components.eater.ablefoods, "BIOLUMINESSENCE")
	inst.components.eater:SetOnEatFn(oneat)
	applyupgrades(inst)
	inst.OnSave = onsave
    inst.OnPreLoad = onpreload
	inst:ListenForEvent("hungerdelta", onhungerchange)
end

return MakePlayerCharacter("bulbman", prefabs, assets, fn, start_inv)
