/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.dakimakuramod.client.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import moe.plushie.dakimakuramod.DakimakuraMod;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ObjModel {
    private Vector3d[] v;
    private Vector2f[] vt;
    private Vector3f[] vn;
    private Face[] faces;
    private int modelList = -1;

    private ObjModel(Vector3d[] v, Vector2f[] vt, Vector3f[] vn, Face[] faces) {
        this.v = v;
        this.vt = vt;
        this.vn = vn;
        this.faces = faces;
    }

    public void render() {
        if (this.modelList == -1) {
            this.modelList = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)this.modelList, (int)4864);
            this.renderModel();
            GL11.glEndList();
        }
        GL11.glCallList((int)this.modelList);
    }

    private void renderModel() {
        Tessellator tess = Tessellator.func_178181_a();
        tess.func_178180_c().func_181668_a(4, DefaultVertexFormats.field_181710_j);
        try {
            for (int i = 0; i < this.faces.length; ++i) {
                Face face = this.faces[i];
                Vector3d v1 = this.v[face.v1 - 1];
                Vector3d v2 = this.v[face.v2 - 1];
                Vector3d v3 = this.v[face.v3 - 1];
                Vector2f vt1 = this.vt[face.vt1 - 1];
                Vector2f vt2 = this.vt[face.vt2 - 1];
                Vector2f vt3 = this.vt[face.vt3 - 1];
                Vector3f vn1 = this.vn[face.vn1 - 1];
                Vector3f vn2 = this.vn[face.vn2 - 1];
                Vector3f vn3 = this.vn[face.vn3 - 1];
                tess.func_178180_c().func_181662_b(-v1.x, -v1.y, v1.z);
                tess.func_178180_c().func_187315_a((double)vt1.x, (double)(-vt1.y));
                tess.func_178180_c().func_181663_c(-vn1.x, -vn1.y, vn1.z);
                tess.func_178180_c().func_181675_d();
                tess.func_178180_c().func_181662_b(-v2.x, -v2.y, v2.z);
                tess.func_178180_c().func_187315_a((double)vt2.x, (double)(-vt2.y));
                tess.func_178180_c().func_181663_c(-vn2.x, -vn2.y, vn2.z);
                tess.func_178180_c().func_181675_d();
                tess.func_178180_c().func_181662_b(-v3.x, -v3.y, v3.z);
                tess.func_178180_c().func_187315_a((double)vt3.x, (double)(-vt3.y));
                tess.func_178180_c().func_181663_c(-vn3.x, -vn3.y, vn3.z);
                tess.func_178180_c().func_181675_d();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        tess.func_78381_a();
    }

    public static ObjModel loadModel(ResourceLocation resourceLocation) {
        byte[] modelData = ObjModel.loadResource(resourceLocation);
        String modelString = new String(modelData);
        String[] modelLines = modelString.split("\\r?\\n");
        ArrayList<Vector3d> vList = new ArrayList<Vector3d>();
        ArrayList<Vector2f> vtList = new ArrayList<Vector2f>();
        ArrayList<Vector3f> vnList = new ArrayList<Vector3f>();
        ArrayList<Face> faceList = new ArrayList<Face>();
        for (int i = 0; i < modelLines.length; ++i) {
            String line = modelLines[i];
            String[] lineSpit = line.split(" ");
            if (lineSpit[0].equals("v")) {
                vList.add(new Vector3d(Double.parseDouble(lineSpit[1]), Double.parseDouble(lineSpit[2]), Double.parseDouble(lineSpit[3])));
            }
            if (lineSpit[0].equals("vt")) {
                vtList.add(new Vector2f(Float.parseFloat(lineSpit[1]), Float.parseFloat(lineSpit[2])));
            }
            if (lineSpit[0].equals("vn")) {
                vnList.add(new Vector3f(Float.parseFloat(lineSpit[1]), Float.parseFloat(lineSpit[2]), Float.parseFloat(lineSpit[3])));
            }
            if (!lineSpit[0].equals("f")) continue;
            faceList.add(new Face(lineSpit[1], lineSpit[2], lineSpit[3]));
        }
        Vector3d[] vArray = vList.toArray(new Vector3d[vList.size()]);
        Vector2f[] vtArray = vtList.toArray(new Vector2f[vtList.size()]);
        Vector3f[] vnArray = vnList.toArray(new Vector3f[vnList.size()]);
        Face[] faces = faceList.toArray(new Face[faceList.size()]);
        return new ObjModel(vArray, vtArray, vnArray, faces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] loadResource(ResourceLocation resourceLocation) {
        ByteArrayOutputStream output;
        InputStream input;
        block8: {
            byte[] byArray;
            block7: {
                input = null;
                output = null;
                try {
                    input = ObjModel.class.getClassLoader().getResourceAsStream("assets/" + resourceLocation.func_110624_b() + "/" + resourceLocation.func_110623_a());
                    if (input != null) {
                        byte[] data;
                        output = new ByteArrayOutputStream();
                        IOUtils.copy((InputStream)input, (OutputStream)output);
                        output.flush();
                        byArray = data = output.toByteArray();
                        IOUtils.closeQuietly((InputStream)input);
                        break block7;
                    }
                    DakimakuraMod.getLogger().error(String.format("Error extracting file %s.", resourceLocation.toString()));
                    IOUtils.closeQuietly((InputStream)input);
                    break block8;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            IOUtils.closeQuietly((OutputStream)output);
            return byArray;
        }
        IOUtils.closeQuietly((OutputStream)output);
        return null;
        finally {
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(output);
        }
    }

    private static class Face {
        public int v1;
        public int v2;
        public int v3;
        public int vt1;
        public int vt2;
        public int vt3;
        public int vn1;
        public int vn2;
        public int vn3;

        public Face(String v1, String v2, String v3) {
            String[] s1 = v1.split("/");
            String[] s2 = v2.split("/");
            String[] s3 = v3.split("/");
            this.v1 = Integer.parseInt(s1[0]);
            this.vt1 = Integer.parseInt(s1[1]);
            this.vn1 = Integer.parseInt(s1[2]);
            this.v2 = Integer.parseInt(s2[0]);
            this.vt2 = Integer.parseInt(s2[1]);
            this.vn2 = Integer.parseInt(s2[2]);
            this.v3 = Integer.parseInt(s3[0]);
            this.vt3 = Integer.parseInt(s3[1]);
            this.vn3 = Integer.parseInt(s3[2]);
        }
    }
}

