/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.dakimakuramod.common;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import moe.plushie.dakimakuramod.DakimakuraMod;
import moe.plushie.dakimakuramod.common.config.ConfigHandler;
import moe.plushie.dakimakuramod.common.lib.LibModInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StringUtils;
import org.apache.commons.io.IOUtils;

public class UpdateCheck
implements Runnable {
    private static final String UPDATE_URL = "http://plushie.moe/app_update/minecraft_mods/dakimakuramod/update.json?version=1.7.10-1.5";
    public static String downloadUrl = "https://minecraft.curseforge.com/projects/dakimakura-mod/files";
    private boolean shownUpdateInfo = false;
    public boolean updateFound = false;
    public String remoteModVersion;

    public UpdateCheck() {
        this.checkForUpdates();
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.CLIENT && event.type == TickEvent.Type.PLAYER && event.phase == TickEvent.Phase.END) {
            this.onPlayerTickEndEvent();
        }
    }

    public void onPlayerTickEndEvent() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().thePlayer;
        if (!this.shownUpdateInfo && this.updateFound) {
            this.shownUpdateInfo = true;
            ChatComponentTranslation updateMessage = new ChatComponentTranslation("chat.dakimakuramod:updateAvailable", new Object[]{this.remoteModVersion});
            ChatComponentTranslation updateURL = new ChatComponentTranslation("chat.dakimakuramod:updateDownload", new Object[0]);
            updateURL.getChatStyle().setUnderlined(Boolean.valueOf(true));
            updateURL.getChatStyle().setColor(EnumChatFormatting.BLUE);
            updateURL.getChatStyle().setChatHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentTranslation("chat.dakimakuramod:updateDownloadRollover", new Object[0])));
            updateURL.getChatStyle().setChatClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, downloadUrl));
            updateMessage.appendText(" ");
            updateMessage.appendSibling((IChatComponent)updateURL);
            player.addChatMessage((IChatComponent)updateMessage);
        }
    }

    public void checkForUpdates() {
        if (!ConfigHandler.checkForUpdates) {
            return;
        }
        new Thread((Runnable)this, "Dakimakura Mod update thread.").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DakimakuraMod.getLogger().info("Starting Update Check");
        String localVersion = "1.7.10-1.5";
        if (LibModInfo.isDevelopmentVersion()) {
            return;
        }
        String downloadData = "";
        HttpURLConnection conn = null;
        try {
            String location = UPDATE_URL;
            while (location != null && !location.isEmpty()) {
                URL url = new URL(location);
                if (conn != null) {
                    conn.disconnect();
                }
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.0; ru; rv:1.9.0.11) Gecko/2009060215 Firefox/3.0.11 (.NET CLR 3.5.30729)");
                conn.setRequestProperty("Referer", "http://1.7.10-1.5");
                conn.connect();
                location = conn.getHeaderField("Location");
            }
            if (conn == null) {
                throw new NullPointerException();
            }
            downloadData = IOUtils.toString((InputStream)conn.getInputStream());
            conn.disconnect();
        }
        catch (Exception e) {
            DakimakuraMod.getLogger().warn("Unable to read from remote version authority.");
            DakimakuraMod.getLogger().warn(e.toString());
            this.updateFound = false;
        }
        finally {
            if (conn != null) {
                try {
                    conn.disconnect();
                }
                catch (Exception e) {}
            }
        }
        if (StringUtils.func_151246_b((String)downloadData)) {
            return;
        }
        try {
            JsonObject json = (JsonObject)new JsonParser().parse(downloadData);
            this.remoteModVersion = json.getAsJsonObject("promos").get("1.7.10-latest").getAsString();
            DakimakuraMod.getLogger().info("Home page: " + json.get("homepage").getAsString());
            downloadUrl = json.get("homepage").getAsString();
            DakimakuraMod.getLogger().info(String.format("Latest version for Minecraft %s is %s.", "1.7.10", this.remoteModVersion));
            if (UpdateCheck.versionCompare(localVersion.replaceAll("-", "."), this.remoteModVersion.replaceAll("-", ".")) < 0) {
                this.updateFound = true;
                DakimakuraMod.getLogger().info("Update needed. New version " + this.remoteModVersion + " your version " + localVersion);
            } else {
                this.updateFound = false;
                DakimakuraMod.getLogger().info("Mod is up to date with the latest version.");
            }
        }
        catch (Exception e) {
            DakimakuraMod.getLogger().warn("Unable to read from remote version authority.");
            DakimakuraMod.getLogger().warn(e.toString());
            this.updateFound = false;
        }
    }

    public static int versionCompare(String str1, String str2) {
        int i;
        String[] vals1 = str1.split("\\.");
        String[] vals2 = str2.split("\\.");
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            int diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
            return Integer.signum(diff);
        }
        return Integer.signum(vals1.length - vals2.length);
    }
}

