/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.dakimakuramod.common.dakimakura;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.Callable;
import javax.imageio.ImageIO;
import moe.plushie.dakimakuramod.DakimakuraMod;
import moe.plushie.dakimakuramod.common.config.ConfigHandler;
import moe.plushie.dakimakuramod.common.dakimakura.Daki;
import moe.plushie.dakimakuramod.common.dakimakura.pack.IDakiPack;
import moe.plushie.dakimakuramod.proxies.ClientProxy;
import org.apache.commons.io.IOUtils;

public class DakiImageData
implements Callable<DakiImageData> {
    private static final String[] VALID_FILE_EXT = new String[]{"png", "jpg", "jpeg"};
    private static final String DEFAULT_NAME_FRONT = "front";
    private static final String DEFAULT_NAME_BACK = "back";
    private final Daki daki;
    private BufferedImage bufferedImageFull;
    private byte[] textureFront;
    private byte[] textureBack;

    public DakiImageData(Daki daki) {
        this.daki = daki;
        this.load();
    }

    public DakiImageData(Daki daki, byte[] textureFront, byte[] textureBack) {
        this.daki = daki;
        this.textureFront = textureFront;
        this.textureBack = textureBack;
    }

    public void load() {
        int i;
        String pathFront = null;
        String pathBack = null;
        IDakiPack dakiPack = DakimakuraMod.getProxy().getDakimakuraManager().getDakiPack(this.daki.getPackDirectoryName());
        if (this.daki.getImageFront() != null) {
            pathFront = this.daki.getDakiDirectoryName() + "/" + this.daki.getImageFront();
        } else {
            for (i = 0; i < VALID_FILE_EXT.length; ++i) {
                if (!dakiPack.resourceExists(this.daki.getDakiDirectoryName() + "/" + DEFAULT_NAME_FRONT + "." + VALID_FILE_EXT[i])) continue;
                pathFront = this.daki.getDakiDirectoryName() + "/" + DEFAULT_NAME_FRONT + "." + VALID_FILE_EXT[i];
                break;
            }
        }
        if (this.daki.getImageBack() != null) {
            pathBack = this.daki.getDakiDirectoryName() + "/" + this.daki.getImageBack();
        } else {
            for (i = 0; i < VALID_FILE_EXT.length; ++i) {
                if (!dakiPack.resourceExists(this.daki.getDakiDirectoryName() + "/" + DEFAULT_NAME_BACK + "." + VALID_FILE_EXT[i])) continue;
                pathBack = this.daki.getDakiDirectoryName() + "/" + DEFAULT_NAME_BACK + "." + VALID_FILE_EXT[i];
                break;
            }
        }
        this.textureFront = dakiPack.getResource(pathFront);
        this.textureBack = dakiPack.getResource(pathBack);
    }

    public Daki getDaki() {
        return this.daki;
    }

    public byte[] getTextureFront() {
        return this.textureFront;
    }

    public byte[] getTextureBack() {
        return this.textureBack;
    }

    public BufferedImage getBufferedImageFull() {
        return this.bufferedImageFull;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DakiImageData call() throws Exception {
        DakiImageData dakiImageData;
        Thread.currentThread().setPriority(1);
        InputStream inputstream = null;
        try {
            inputstream = this.textureFront != null ? new ByteArrayInputStream(this.textureFront) : this.getMissingTexture();
            BufferedImage bufferedimageFront = ImageIO.read(inputstream);
            inputstream.close();
            inputstream = this.textureBack != null ? new ByteArrayInputStream(this.textureBack) : this.getMissingTexture();
            BufferedImage bufferedimageBack = ImageIO.read(inputstream);
            inputstream.close();
            int heightF = bufferedimageFront.getHeight();
            int heightB = bufferedimageBack.getHeight();
            int maxTexture = Math.max(heightF, heightB);
            int textureSize = this.getMaxTextureSize();
            textureSize = Math.min(textureSize, this.getNextPowerOf2(maxTexture));
            bufferedimageFront = this.resize(bufferedimageFront, textureSize / 2, textureSize, this.daki.isSmooth());
            bufferedimageBack = this.resize(bufferedimageBack, textureSize / 2, textureSize, this.daki.isSmooth());
            BufferedImage bufferedimageBackFlipped = new BufferedImage(bufferedimageBack.getWidth(), bufferedimageBack.getHeight(), bufferedimageBack.getType());
            AffineTransform tx = AffineTransform.getScaleInstance(-1.0, 1.0);
            tx.translate(-bufferedimageBack.getWidth(null), 0.0);
            AffineTransformOp op = new AffineTransformOp(tx, 1);
            bufferedimageBackFlipped = op.filter(bufferedimageBack, bufferedimageBackFlipped);
            this.bufferedImageFull = new BufferedImage(textureSize, textureSize, 1);
            Graphics2D g2d = this.bufferedImageFull.createGraphics();
            g2d.drawImage((Image)bufferedimageFront, 0, 0, null);
            g2d.drawImage((Image)bufferedimageBackFlipped, textureSize / 2, 0, null);
            g2d.dispose();
            this.textureFront = null;
            this.textureBack = null;
            dakiImageData = this;
        }
        catch (Exception e) {
            DakiImageData dakiImageData2;
            try {
                e.printStackTrace();
                dakiImageData2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputstream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputstream);
            return dakiImageData2;
        }
        IOUtils.closeQuietly((InputStream)inputstream);
        return dakiImageData;
    }

    private InputStream getMissingTexture() {
        return DakiImageData.class.getClassLoader().getResourceAsStream("assets/dakimakuramod/textures/models/missing.png");
    }

    private int getNextPowerOf2(int value) {
        return (int)Math.pow(2.0, 32 - Integer.numberOfLeadingZeros(value - 1));
    }

    private int getMaxTextureSize() {
        int maxGpuSize = ((ClientProxy)DakimakuraMod.getProxy()).getMaxGpuTextureSize();
        int maxConfigSize = ConfigHandler.textureMaxSize;
        return Math.min(maxGpuSize, maxConfigSize);
    }

    private BufferedImage resize(BufferedImage img, int newW, int newH, boolean smooth) {
        int hint = 4;
        if (!smooth) {
            hint = 2;
        }
        Image tmp = img.getScaledInstance(newW, newH, hint);
        BufferedImage dimg = new BufferedImage(newW, newH, 1);
        Graphics2D g2d = dimg.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return dimg;
    }
}

