/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.dakimakuramod.common.dakimakura;

import java.util.ArrayList;
import java.util.HashMap;
import moe.plushie.dakimakuramod.DakimakuraMod;
import moe.plushie.dakimakuramod.common.dakimakura.Daki;
import moe.plushie.dakimakuramod.common.dakimakura.DakiImageData;
import moe.plushie.dakimakuramod.common.network.PacketHandler;
import moe.plushie.dakimakuramod.common.network.message.server.MessageServerSendTextures;
import moe.plushie.dakimakuramod.proxies.ClientProxy;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

public class DakiSendHelper {
    private static final HashMap<Daki, byte[]> unfinishedSkins = new HashMap();
    private static final int MAX_PACKET_SIZE = 30000;

    public static void sendDakiTexturesToClient(EntityPlayerMP player, Daki daki, DakiImageData imageData) {
        int i;
        int sizeFront = 0;
        int sizeBack = 0;
        if (imageData.getTextureFront() != null) {
            sizeFront = imageData.getTextureFront().length;
        }
        if (imageData.getTextureBack() != null) {
            sizeBack = imageData.getTextureBack().length;
        }
        if (sizeFront == 0 & sizeBack == 0) {
            MessageServerSendTextures message = new MessageServerSendTextures(daki, sizeFront, sizeBack, null);
            PacketHandler.NETWORK_WRAPPER.sendTo((IMessage)message, player);
            return;
        }
        byte[] totalBytes = new byte[sizeFront + sizeBack];
        if (sizeFront > 0) {
            System.arraycopy(imageData.getTextureFront(), 0, totalBytes, 0, sizeFront);
        }
        if (sizeBack > 0) {
            System.arraycopy(imageData.getTextureBack(), 0, totalBytes, sizeFront, sizeBack);
        }
        ArrayList<MessageServerSendTextures> packetQueue = new ArrayList<MessageServerSendTextures>();
        int packetsNeeded = (int)Math.ceil((double)totalBytes.length / 30000.0);
        int bytesLeftToSend = totalBytes.length;
        int bytesSent = 0;
        for (i = 0; i < packetsNeeded; ++i) {
            boolean lastPacket = i == packetsNeeded - 1;
            byte[] messageData = lastPacket ? new byte[bytesLeftToSend] : new byte[30000];
            System.arraycopy(totalBytes, bytesSent, messageData, 0, messageData.length);
            MessageServerSendTextures message = new MessageServerSendTextures(daki, sizeFront, sizeBack, messageData);
            packetQueue.add(message);
            bytesLeftToSend -= messageData.length;
            bytesSent += messageData.length;
        }
        for (i = 0; i < packetQueue.size(); ++i) {
            PacketHandler.NETWORK_WRAPPER.sendTo((IMessage)packetQueue.get(i), player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void gotDakiTexturePartFromServer(Daki daki, int sizeFront, int sizeBack, byte[] data) {
        boolean lastPacket = true;
        if (data != null) {
            lastPacket = data.length < 30000;
        }
        byte[] oldSkinData = unfinishedSkins.get(daki);
        byte[] newSkinData = null;
        if (oldSkinData != null) {
            newSkinData = ArrayUtils.addAll((byte[])oldSkinData, (byte[])data);
            unfinishedSkins.remove(daki);
        } else {
            newSkinData = data;
        }
        if (!lastPacket) {
            unfinishedSkins.put(daki, newSkinData);
        } else {
            byte[] data1 = null;
            byte[] data2 = null;
            try {
                if (sizeFront > 0) {
                    data1 = new byte[sizeFront];
                    System.arraycopy(newSkinData, 0, data1, 0, sizeFront);
                }
                if (sizeBack > 0) {
                    data2 = new byte[sizeBack];
                    System.arraycopy(newSkinData, sizeFront, data2, 0, sizeBack);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            DakiImageData imageData = new DakiImageData(daki, data1, data2);
            ((ClientProxy)DakimakuraMod.getProxy()).getDakiTextureManager().serverSentTextures(imageData);
        }
    }
}

