/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.dakimakuramod.common.dakimakura.pack;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import moe.plushie.dakimakuramod.DakimakuraMod;
import moe.plushie.dakimakuramod.common.dakimakura.Daki;
import moe.plushie.dakimakuramod.common.dakimakura.pack.AbstractDakiPack;
import moe.plushie.dakimakuramod.common.dakimakura.serialize.DakiJsonSerializer;
import net.minecraft.util.StringUtils;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class DakiPackFolder
extends AbstractDakiPack {
    public DakiPackFolder(String folder) {
        super(folder);
    }

    @Override
    public String getName() {
        return this.getResourceName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getResource(String path) {
        FileInputStream inputStream = null;
        byte[] data = null;
        try {
            inputStream = new FileInputStream(new File(this.dakiManager.getPackFolder(), this.getResourceName() + "/" + path));
            data = IOUtils.toByteArray((InputStream)inputStream);
            inputStream.close();
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        return data;
    }

    @Override
    public boolean resourceExists(String path) {
        return new File(this.dakiManager.getPackFolder(), this.getResourceName() + "/" + path).exists();
    }

    public DakiPackFolder loadPack() {
        File dir = new File(this.dakiManager.getPackFolder(), this.getResourceName());
        DakimakuraMod.getLogger().info("Loading Pack: " + dir.getName());
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            this.loadDaki(dir, files[i]);
        }
        return this;
    }

    private void loadDaki(File packDir, File dakieDir) {
        File dakiFile = new File(dakieDir, "daki-info.json");
        if (dakiFile.exists()) {
            Daki dakimakura;
            String dakiJson = this.readStringFromFile(dakiFile);
            if (!StringUtils.func_151246_b((String)dakiJson) && (dakimakura = DakiJsonSerializer.deserialize(dakiJson, packDir.getName(), dakieDir.getName())) != null) {
                this.addDakiToMap(dakimakura);
            }
        } else {
            this.addDakiToMap(new Daki(packDir.getName(), dakieDir.getName()));
        }
    }

    private void addDakiToMap(Daki daki) {
        this.addDaki(daki);
    }

    private void writeStringToFile(File file, String data) {
        try {
            FileUtils.writeStringToFile((File)file, (String)data, (Charset)Charsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String readStringFromFile(File file) {
        String data = null;
        try {
            data = FileUtils.readFileToString((File)file, (Charset)Charsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }
}

