/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.dakimakuramod.common.entities;

import io.netty.buffer.ByteBuf;
import moe.plushie.dakimakuramod.DakimakuraMod;
import moe.plushie.dakimakuramod.common.block.ModBlocks;
import moe.plushie.dakimakuramod.common.dakimakura.Daki;
import moe.plushie.dakimakuramod.common.dakimakura.serialize.DakiNbtSerializer;
import moe.plushie.dakimakuramod.common.items.block.ItemBlockDakimakura;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityDakimakura
extends Entity
implements IEntityAdditionalSpawnData {
    private static final String TAG_FLIPPED = "flipped";
    private static final String TAG_ROTATION = "rotation";
    private static final DataParameter<Boolean> FLIPPED = EntityDataManager.func_187226_a(EntityDakimakura.class, (DataSerializer)DataSerializers.field_187198_h);
    private String packDirName;
    private String dakiDirName;
    private EnumFacing rotation;

    public EntityDakimakura(World world) {
        super(world);
        this.field_70145_X = true;
        this.func_70105_a(4.0f, 1.0f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(FLIPPED, (Object)false);
    }

    public void setDaki(Daki daki) {
        if (daki != null) {
            this.packDirName = daki.getPackDirectoryName();
            this.dakiDirName = daki.getDakiDirectoryName();
        } else {
            this.packDirName = null;
            this.dakiDirName = null;
        }
    }

    public void func_70071_h_() {
        if (!this.func_130014_f_().field_72995_K) {
            BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v);
            IBlockState blockState = this.func_130014_f_().func_180495_p(pos);
            Block block = blockState.func_177230_c();
            if (!block.isBed(blockState, (IBlockAccess)this.func_130014_f_(), pos, null)) {
                this.dropAsItem();
                this.func_70106_y();
            }
        }
    }

    public void dropAsItem() {
        Daki daki = this.getDaki();
        ItemStack itemStack = new ItemStack(ModBlocks.blockDakimakura);
        if (daki != null) {
            itemStack.func_77982_d(new NBTTagCompound());
            DakiNbtSerializer.serialize(daki, itemStack.func_77978_p());
            if (this.isFlipped()) {
                ItemBlockDakimakura.setFlipped(itemStack, true);
            }
        }
        EntityItem entityItem = new EntityItem(this.func_130014_f_(), this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, itemStack);
        this.func_130014_f_().func_72838_d((Entity)entityItem);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_150297_b("dakiPackName", 8) & compound.func_150297_b("dakiDirName", 8)) {
            this.packDirName = compound.func_74779_i("dakiPackName");
            this.dakiDirName = compound.func_74779_i("dakiDirName");
        }
        if (compound.func_150297_b(TAG_ROTATION, 3)) {
            this.rotation = EnumFacing.values()[compound.func_74762_e(TAG_ROTATION)];
        }
        this.setFlipped(compound.func_74767_n(TAG_FLIPPED));
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.packDirName != null & this.dakiDirName != null) {
            compound.func_74778_a("dakiPackName", this.packDirName);
            compound.func_74778_a("dakiDirName", this.dakiDirName);
        }
        if (this.rotation != null) {
            compound.func_74768_a(TAG_ROTATION, this.rotation.ordinal());
        }
        compound.func_74757_a(TAG_FLIPPED, this.isFlipped());
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeDouble(this.field_70165_t);
        buf.writeDouble(this.field_70163_u);
        buf.writeDouble(this.field_70161_v);
        if (this.packDirName != null & this.dakiDirName != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.packDirName);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.dakiDirName);
        } else {
            buf.writeBoolean(false);
        }
        if (this.rotation != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.rotation.ordinal());
        } else {
            buf.writeBoolean(false);
        }
    }

    public void readSpawnData(ByteBuf buf) {
        this.field_70165_t = buf.readDouble();
        this.field_70163_u = buf.readDouble();
        this.field_70161_v = buf.readDouble();
        if (buf.readBoolean()) {
            this.packDirName = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.dakiDirName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        if (buf.readBoolean()) {
            this.rotation = EnumFacing.values()[buf.readInt()];
        }
    }

    public Daki getDaki() {
        return DakimakuraMod.getProxy().getDakimakuraManager().getDakiFromMap(this.packDirName, this.dakiDirName);
    }

    public boolean isFlipped() {
        return (Boolean)this.field_70180_af.func_187225_a(FLIPPED);
    }

    public void setFlipped(boolean flipped) {
        this.field_70180_af.func_187227_b(FLIPPED, (Object)flipped);
    }

    public void flip() {
        this.setFlipped(!this.isFlipped());
    }

    public void setRotation(EnumFacing rotation) {
        this.rotation = rotation;
    }

    public EnumFacing getRotation() {
        return this.rotation;
    }

    public boolean isDakiOverBlock(BlockPos blockPos) {
        BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v);
        if (pos.equals((Object)blockPos)) {
            return true;
        }
        return (pos = pos.func_177972_a(this.rotation)).equals((Object)blockPos);
    }
}

