/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.dakimakuramod.common.handler;

import java.util.ArrayList;
import moe.plushie.dakimakuramod.common.entities.EntityDakimakura;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BedHandler {
    public BedHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getFace() == null) {
            return;
        }
        World world = event.getWorld();
        EntityPlayer entityPlayer = event.getEntityPlayer();
        BlockPos blockPos = event.getPos();
        IBlockState blockState = world.func_180495_p(blockPos);
        if (!blockState.func_177230_c().isBed(blockState, (IBlockAccess)world, blockPos, (Entity)entityPlayer)) {
            return;
        }
        if (!entityPlayer.func_70093_af()) {
            return;
        }
        AxisAlignedBB aabb = new AxisAlignedBB(blockPos.func_177982_a(-1, 0, -1), blockPos.func_177982_a(1, 2, 1));
        ArrayList entityList = (ArrayList)world.func_72872_a(EntityDakimakura.class, aabb);
        if (entityList.isEmpty()) {
            return;
        }
        boolean flipped = false;
        for (int i = 0; i < entityList.size(); ++i) {
            EntityDakimakura entityDaki;
            Entity entity = (Entity)entityList.get(i);
            if (!(entity instanceof EntityDakimakura) || !(entityDaki = (EntityDakimakura)entity).isDakiOverBlock(blockPos) || world.field_72995_K) continue;
            if (event.getHand() == EnumHand.MAIN_HAND) {
                entityDaki.flip();
                flipped = true;
            }
            if (event.getHand() != EnumHand.OFF_HAND) continue;
            entityDaki.dropAsItem();
            entityDaki.func_70106_y();
        }
        if (flipped) {
            event.setCanceled(true);
        }
    }
}

