/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.dakimakuramod.common.items.block;

import java.util.ArrayList;
import java.util.List;
import moe.plushie.dakimakuramod.DakimakuraMod;
import moe.plushie.dakimakuramod.common.block.BlockDakimakura;
import moe.plushie.dakimakuramod.common.dakimakura.Daki;
import moe.plushie.dakimakuramod.common.dakimakura.serialize.DakiNbtSerializer;
import moe.plushie.dakimakuramod.common.entities.EntityDakimakura;
import moe.plushie.dakimakuramod.common.items.block.ModItemBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockDakimakura
extends ModItemBlock {
    public ItemBlockDakimakura(Block block) {
        super(block);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this, 1, 0));
            ArrayList<Daki> dakiList = DakimakuraMod.getProxy().getDakimakuraManager().getDakiList();
            for (int i = 0; i < dakiList.size(); ++i) {
                ItemStack itemStack = new ItemStack((Item)this, 1, 0);
                itemStack.func_77982_d(new NBTTagCompound());
                Daki daki = dakiList.get(i);
                DakiNbtSerializer.serialize(daki, itemStack.func_77978_p());
                items.add((Object)itemStack);
            }
        }
    }

    public static boolean isFlipped(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        if (!itemStack.func_77942_o()) {
            return false;
        }
        return DakiNbtSerializer.isFlipped(itemStack.func_77978_p());
    }

    public static ItemStack setFlipped(ItemStack itemStack, boolean flipped) {
        if (itemStack == null) {
            return null;
        }
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        DakiNbtSerializer.setFlipped(itemStack.func_77978_p(), flipped);
        return itemStack;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemStack = playerIn.func_184586_b(handIn);
        if (playerIn.func_70093_af()) {
            boolean flipped = ItemBlockDakimakura.isFlipped(itemStack);
            itemStack = ItemBlockDakimakura.setFlipped(itemStack, !flipped);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (!block.func_176200_f((IBlockAccess)worldIn, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if (stack.func_190916_E() != 0 && player.func_175151_a(pos, facing, stack) && worldIn.func_190527_a(Blocks.field_150348_b, pos, false, facing, (Entity)null)) {
            EnumFacing[] rots = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST};
            int rot = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            EnumFacing rotation = rots[rot].func_176734_d();
            if (this.canPlaceDakiAt(worldIn, player, stack, pos, facing, rotation)) {
                if (block.isBed(iblockstate, (IBlockAccess)worldIn, pos, (Entity)player)) {
                    this.placeAsEntity(worldIn, player, stack, pos, facing, rotation);
                } else {
                    this.placeDakiAt(worldIn, player, stack, pos, facing, rotation);
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.FAIL;
    }

    private boolean canPlaceDakiAt(World world, EntityPlayer entityPlayer, ItemStack itemStack, BlockPos pos, EnumFacing side, EnumFacing rotation) {
        if (this.canPlaceAtLocation(world, entityPlayer, itemStack, pos, side)) {
            if (side != EnumFacing.UP) {
                rotation = EnumFacing.UP;
            }
            if (side == EnumFacing.DOWN) {
                rotation = EnumFacing.UP;
                pos = pos.func_177972_a(EnumFacing.DOWN);
            }
            if (this.canPlaceAtLocation(world, entityPlayer, itemStack, pos = pos.func_177972_a(rotation), side)) {
                return true;
            }
        }
        return false;
    }

    private void placeDakiAt(World world, EntityPlayer entityPlayer, ItemStack itemStack, BlockPos pos, EnumFacing side, EnumFacing rotation) {
        IBlockState blockstate = this.field_150939_a.func_176223_P();
        blockstate = blockstate.func_177226_a((IProperty)BlockDakimakura.PROPERTY_STANDING, (Comparable)Boolean.valueOf(false));
        blockstate = blockstate.func_177226_a((IProperty)BlockDakimakura.PROPERTY_DIRECTION, (Comparable)rotation);
        blockstate = blockstate.func_177226_a((IProperty)BlockDakimakura.PROPERTY_TOP, (Comparable)Boolean.valueOf(false));
        if (side != EnumFacing.UP & side != EnumFacing.DOWN) {
            blockstate = blockstate.func_177226_a((IProperty)BlockDakimakura.PROPERTY_DIRECTION, (Comparable)side.func_176734_d());
            blockstate = blockstate.func_177226_a((IProperty)BlockDakimakura.PROPERTY_STANDING, (Comparable)Boolean.valueOf(true));
            rotation = EnumFacing.UP;
        }
        if (side == EnumFacing.DOWN) {
            blockstate = blockstate.func_177226_a((IProperty)BlockDakimakura.PROPERTY_STANDING, (Comparable)Boolean.valueOf(true));
            rotation = EnumFacing.UP;
            pos = pos.func_177972_a(EnumFacing.DOWN);
        }
        this.placeBlockAt(itemStack, entityPlayer, world, pos, side, 0.0f, 0.0f, 0.0f, blockstate);
        SoundType soundtype = this.field_150939_a.func_185467_w();
        world.func_184133_a(entityPlayer, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        itemStack.func_190918_g(1);
        world.func_180497_b(pos, this.field_150939_a, 1, 0);
        blockstate = blockstate.func_177226_a((IProperty)BlockDakimakura.PROPERTY_TOP, (Comparable)Boolean.valueOf(true));
        pos = pos.func_177972_a(rotation);
        this.placeBlockAt(itemStack, entityPlayer, world, pos, side, 0.0f, 0.0f, 0.0f, blockstate);
        world.func_180497_b(pos, this.field_150939_a, 1, 0);
    }

    private boolean canPlaceAtLocation(World world, EntityPlayer entityPlayer, ItemStack itemStack, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (!entityPlayer.func_175151_a(pos, side, itemStack)) {
            return false;
        }
        if (iblockstate.func_185904_a().func_76220_a()) {
            return false;
        }
        return block.func_176200_f((IBlockAccess)world, pos);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!world.func_180501_a(pos, newState, 2)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this.field_150939_a) {
            ItemBlockDakimakura.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
            this.field_150939_a.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
        }
        return true;
    }

    private void placeAsEntity(World world, EntityPlayer entityPlayer, ItemStack itemStack, BlockPos pos, EnumFacing side, EnumFacing rotation) {
        if (world.field_72995_K) {
            return;
        }
        Daki daki = DakiNbtSerializer.deserialize(itemStack.func_77978_p());
        EntityDakimakura entityDakimakura = new EntityDakimakura(world);
        entityDakimakura.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        entityDakimakura.setDaki(daki);
        entityDakimakura.setFlipped(ItemBlockDakimakura.isFlipped(itemStack));
        entityDakimakura.setRotation(rotation);
        world.func_72838_d((Entity)entityDakimakura);
        DakimakuraMod.getLogger().info("Placing daki at " + pos);
        SoundType soundtype = this.field_150939_a.func_185467_w();
        world.func_184133_a(entityPlayer, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        itemStack.func_190918_g(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        Daki daki = DakiNbtSerializer.deserialize(stack.func_77978_p());
        if (daki != null) {
            String textFlip = I18n.func_135052_a((String)(stack.func_77977_a() + ".tooltip.flip"), (Object[])new Object[0]);
            tooltip.add(I18n.func_135052_a((String)textFlip, (Object[])new Object[0]));
            daki.addInformation(stack, tooltip);
        } else {
            tooltip.add(I18n.func_135052_a((String)(stack.func_77977_a() + ".tooltip.blank"), (Object[])new Object[0]));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_179222_a(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_150431_aC && block.func_176200_f((IBlockAccess)world, pos)) {
            side = EnumFacing.UP;
        } else if (!block.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(side);
        }
        return world.func_190527_a(Blocks.field_150348_b, pos, false, side, (Entity)null);
    }
}

