/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.dakimakuramod.common.network.message.server;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import moe.plushie.dakimakuramod.DakimakuraMod;
import net.minecraft.util.Util;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.Sys;

public class MessageServerCommand
implements IMessage,
IMessageHandler<MessageServerCommand, IMessage> {
    private ServerCommandType commandType;

    public MessageServerCommand() {
    }

    public MessageServerCommand(ServerCommandType commandType) {
        this.commandType = commandType;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.commandType.ordinal());
    }

    public void fromBytes(ByteBuf buf) {
        this.commandType = ServerCommandType.values()[buf.readByte()];
    }

    public IMessage onMessage(MessageServerCommand message, MessageContext ctx) {
        switch (message.commandType) {
            case OPEN_PACK_FOLDER: {
                this.openPackFolder();
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void openPackFolder() {
        File packFolder = DakimakuraMod.getProxy().getDakimakuraManager().getPackFolder();
        String packPath = packFolder.getAbsolutePath();
        if (Util.func_110647_a() == Util.EnumOS.OSX) {
            try {
                Runtime.getRuntime().exec(new String[]{"/usr/bin/open", packPath});
                return;
            }
            catch (IOException ioexception1) {
                DakimakuraMod.getLogger().error("Couldn't open file: " + ioexception1);
            }
        } else if (Util.func_110647_a() == Util.EnumOS.WINDOWS) {
            String s1 = String.format("cmd.exe /C start \"Open file\" \"%s\"", packPath);
            try {
                Runtime.getRuntime().exec(s1);
                return;
            }
            catch (IOException ioexception) {
                DakimakuraMod.getLogger().error("Couldn't open file: " + ioexception);
            }
        }
        boolean openedFailed = false;
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, packFolder.toURI());
        }
        catch (Throwable throwable) {
            DakimakuraMod.getLogger().error("Couldn't open link: " + throwable);
            openedFailed = true;
        }
        if (openedFailed) {
            DakimakuraMod.getLogger().error("Opening via system class!");
            Sys.openURL((String)("file://" + packPath));
        }
    }

    public static enum ServerCommandType {
        OPEN_PACK_FOLDER;

    }
}

