/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.dakimakuramod.common.network.message.server;

import io.netty.buffer.ByteBuf;
import moe.plushie.dakimakuramod.DakimakuraMod;
import moe.plushie.dakimakuramod.common.dakimakura.Daki;
import moe.plushie.dakimakuramod.common.dakimakura.DakiSendHelper;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageServerSendTextures
implements IMessage,
IMessageHandler<MessageServerSendTextures, IMessage> {
    private Daki daki;
    int sizeFront = 0;
    int sizeBack = 0;
    private byte[] data;

    public MessageServerSendTextures() {
    }

    public MessageServerSendTextures(Daki daki, int sizeFront, int sizeBack, byte[] data) {
        this.daki = daki;
        this.sizeFront = sizeFront;
        this.sizeBack = sizeBack;
        this.data = data;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.daki.getPackDirectoryName() + ":" + this.daki.getDakiDirectoryName()));
        buf.writeInt(this.sizeFront);
        buf.writeInt(this.sizeBack);
        buf.writeBoolean(this.data != null);
        if (this.data != null) {
            buf.writeInt(this.data.length);
            buf.writeBytes(this.data);
        }
    }

    public void fromBytes(ByteBuf buf) {
        String path = ByteBufUtils.readUTF8String((ByteBuf)buf);
        String[] pathSplit = path.split(":");
        this.daki = DakimakuraMod.getProxy().getDakimakuraManager().getDakiFromMap(pathSplit[0], pathSplit[1]);
        this.sizeFront = buf.readInt();
        this.sizeBack = buf.readInt();
        if (buf.readBoolean()) {
            int size = buf.readInt();
            this.data = new byte[size];
            buf.readBytes(this.data);
        }
    }

    public IMessage onMessage(MessageServerSendTextures message, MessageContext ctx) {
        this.sendToClientManager(message.daki, message.sizeFront, message.sizeBack, message.data);
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void sendToClientManager(Daki daki, int sizeFront, int sizeBack, byte[] data) {
        DakiSendHelper.gotDakiTexturePartFromServer(daki, sizeFront, sizeBack, data);
    }
}

