/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.dakimakuramod.common.tileentities;

import java.util.List;
import moe.plushie.dakimakuramod.DakimakuraMod;
import moe.plushie.dakimakuramod.common.block.BlockDakimakura;
import moe.plushie.dakimakuramod.common.block.ModBlocks;
import moe.plushie.dakimakuramod.common.config.ConfigHandler;
import moe.plushie.dakimakuramod.common.dakimakura.Daki;
import moe.plushie.dakimakuramod.common.dakimakura.serialize.DakiNbtSerializer;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityDakimakura
extends TileEntity {
    private String packDirName;
    private String dakiDirName;
    private boolean flipped;

    public void setDaki(Daki daki) {
        if (daki != null) {
            this.packDirName = daki.getPackDirectoryName();
            this.dakiDirName = daki.getDakiDirectoryName();
        } else {
            this.packDirName = null;
            this.dakiDirName = null;
        }
        this.func_70296_d();
        this.syncWithClients();
    }

    public Daki getDaki() {
        return DakimakuraMod.getProxy().getDakimakuraManager().getDakiFromMap(this.packDirName, this.dakiDirName);
    }

    public void setFlipped(boolean flipped) {
        this.flipped = flipped;
        this.func_70296_d();
        this.syncWithClients();
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void flip() {
        this.setFlipped(!this.flipped);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("dakiPackName", 8) & compound.func_150297_b("dakiDirName", 8)) {
            this.packDirName = compound.func_74779_i("dakiPackName");
            this.dakiDirName = compound.func_74779_i("dakiDirName");
        }
        this.flipped = DakiNbtSerializer.isFlipped(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.packDirName != null & this.dakiDirName != null) {
            compound.func_74778_a("dakiPackName", this.packDirName);
            compound.func_74778_a("dakiDirName", this.dakiDirName);
        }
        DakiNbtSerializer.setFlipped(compound, this.flipped);
        return compound;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        this.func_189515_b(compound);
        return compound;
    }

    public Packet getDescriptionPacket() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 5, this.func_189517_E_());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        this.func_145839_a(compound);
        super.onDataPacket(net, packet);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return ConfigHandler.dakiRenderDist;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        IBlockState blockState = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (blockState.func_177230_c() == ModBlocks.blockDakimakura) {
            boolean standing = (Boolean)blockState.func_177229_b((IProperty)BlockDakimakura.PROPERTY_STANDING);
            EnumFacing rotation = (EnumFacing)blockState.func_177229_b((IProperty)BlockDakimakura.PROPERTY_DIRECTION);
            if (standing) {
                return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 2, 1));
            }
            AxisAlignedBB[] rots = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, -1.0, 1.0, (double)0.28f, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.28f, 2.0), new AxisAlignedBB(-1.0, 0.0, 0.0, 1.0, (double)0.28f, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 2.0, (double)0.28f, 1.0)};
            return rots[rotation.ordinal() - 2 & 3].func_186670_a(this.field_174879_c);
        }
        return INFINITE_EXTENT_AABB;
    }

    public void syncWithClients() {
        if (!this.func_145831_w().field_72995_K) {
            TileEntityDakimakura.syncWithNearbyPlayers(this);
        }
    }

    public static void syncWithNearbyPlayers(TileEntity tileEntity) {
        World world = tileEntity.func_145831_w();
        List players = world.field_73010_i;
        for (EntityPlayer player : players) {
            if (!(player instanceof EntityPlayerMP)) continue;
            EntityPlayerMP mp = (EntityPlayerMP)player;
            if (!(tileEntity.func_145835_a(mp.field_70165_t, mp.field_70163_u, mp.field_70161_v) < 64.0)) continue;
            mp.field_71135_a.func_147359_a((Packet)tileEntity.func_189518_D_());
        }
    }
}

