import log, { mark } from '../utils/log';

export default class Event {
  on(event, fn, fire, ctx) {
    if (typeof fn != "function") {
      log(`${event} fn must be a function`)
      return;
    }

    this._stores || (this._stores = {});
    this._stores[event] || (this._stores[event] = []);
    this._stores[event].push({ cb: fn, fire, ctx: ctx });
  }
  emit(event, ctx) {
    this._stores = this._stores || {}
    var store = this._stores[event],
      args
    if (store) {

    //  console.log(store);


      store = store.slice(0);
      args = [].slice.call(arguments, 2);
      for (var i = 0, len = store.length; i < len; i++) {
        if (!ctx || store[i].ctx === ctx) {
      //     console.log('trigger event', event, i , store[i]);
          // mark(`${ctx.route}#${store[i].fire.scope}#${event}`);
          store[i].cb.apply(store[i].fire, args);
          // mark(`${ctx.route}#${store[i].fire.scope}#${event}`, `${ctx.route}#${store[i].fire.scope}#${event}#end`);
        }
      }
    }
  }
  offctx(ctx, fire) {
    this._stores = this._stores || {};
    for (let event in this._stores) {
      this._stores[event] = this._stores[event].filter(e => e.ctx !== ctx);
    }
  }
  off(event, ctx) {
    this._stores = this._stores || {}
      // all
    if (!arguments.length) {
      this._stores = {}
      return
    }
    // specific event
    var store = this._stores[event]
    if (!store) return
      // remove all handlers
    if (arguments.length === 1) {
      delete this._stores[event]
      return
    }
    // remove specific handler
    this._stores[event] = this._stores[event].filter(e => e.ctx !== ctx);
  }
}
