// 列表选择功能
import log from '../utils//log';

export default {
    data: {
        items: [],
        icon: '../../images/Unchecked-Checkbox-50.png',
        iconChecked: '../../images/Checked-Checkbox2-50.png',
        nav: '../../images/Forward-50.png',
        checkType: ''
    },
    selected: [],
    checkType: '',
    deselectable: false,
    setCheckType(checkType, timer = 300) {
        this.setDelayData(
            {
                checkType
            },
            timer
        );
        this.checkType = checkType;
    },
    onLoad() {
        this.on('buttonClick', this._handleButtonEvent);
    },
    _handleButtonEvent(scope, button, item, gindex, index) {
        if (scope === this.scope) {
            // console.log('aaaaaa', scope, button, item, gindex, index);
            if (button === 'checkRow' || button === 'radioRow') {
                this.checkListItem(gindex, index, button === 'checkRow' ? 'check' : 'radio');
            }
        }
    },
    methods: {
        handleGroupEdit(e) {
            const { gindex } = e.currentTarget.dataset;
            const data = this.getData();
            this.setData({
                [`items[${gindex}].edit`]: !data.items[gindex].edit,
                [`items[${gindex}].header.edit`]: !data.items[gindex].edit
            });
        },
        handleCheckGroup(e) {
            const { gindex } = e.currentTarget.dataset;
            const data = this.getData();

            if (this.checkType === 'check') {
                this.checkGroupItem(gindex, !data.items[gindex].checked);
                this.emit('checkable-tap', this.page, this.getSelectedItems());
            }
            this.itemNav(data.items[gindex]);
        },
        checkListItem(gindex, index, checkType) {
            const data = this.getData();

            const newData = {};
            const gitem = data.items[gindex];
            const item = data.items[gindex].items[index];

            if (!item || item.uncheckable) {
                return;
            }

            checkType || (checkType = gitem.checkType || this.checkType);
            if (checkType === 'radio' || checkType === 'check') {
                if (checkType === 'radio') {
                    if (item.checked && this.deselectable === false) {
                        return;
                    }
                    this.selected.forEach((sitem) => {
                        if (sitem[0] !== gindex || sitem[1] !== index) {
                            newData[`items[${sitem[0]}].items[${sitem[1]}].checked`] = false;
                        }
                    });
                    this.selected = [];
                }

                if (item.checked) {
                    const si = this.selected.findIndex((aa) => aa[0] === gindex && aa[1] === index);
                    this.selected.splice(si, 1);
                    newData[`items[${gindex}].items[${index}].checked`] = false;
                    newData[`items[${gindex}].checked`] = false;
                    newData[`items[${gindex}].header.checked`] = false;
                } else {
                    this.selected.push([ gindex, index ]);
                    newData[`items[${gindex}].items[${index}].checked`] = true;
                    const selectedLength = this.selected.filter((item) => item[0] === gindex).length;
                    if (selectedLength === data.items[gindex].items.length) {
                        newData[`items[${gindex}].checked`] = true;
                        newData[`items[${gindex}].header.checked`] = true;
                    }
                }
                this.setData(newData);

           

                this.emit('checkable-tap', this.page, this.getSelectedItems(), [ gindex, index ], item);
            }
        },
        handleTap(e) {
            const { index, gindex } = e.currentTarget.dataset;
            this.checkListItem(gindex, index);
        }
    },
    checkGroupItem(gindex, checked) {
        const data = this.getData();
        const newData = {};
        data.items[gindex].items.forEach((item, index) => {
            newData[`items[${gindex}].items[${index}].checked`] = checked;
        });
        newData[`items[${gindex}].checked`] = checked;
        newData[`items[${gindex}].header.checked`] = checked;
        this.setData(newData);
        this.updateSelected();
    },
    getTapGItem(e) {
        const { gindex } = e.currentTarget.dataset;
        const data = this.getData();
        return data.items[gindex];
    },
    getTapItem(e) {
        const { gindex, index } = e.currentTarget.dataset;
        const data = this.getData();
        return data.items[gindex].items[index];
    },
    checkAllItem(checked) {
        const data = this.getData();
        const newData = {};
        data.items.forEach((gitem, gindex) => {
            gitem.items.forEach((item, index) => {
                newData[`items[${gindex}].items[${index}].checked`] = checked;
            });
            newData[`items[${gindex}].checked`] = checked;
            newData[`items[${gindex}].header.checked`] = checked;
        });
        this.setData(newData);
        this.updateSelected();
    },
    getSelectedItems() {
        const selected = [];
        const data = this.getData();
        this.selected.forEach((sitem) => {
            selected.push(Object.assign({}, data.items[sitem[0]].items[sitem[1]], { indexes: [ sitem[0], sitem[1] ] }));
        });
        return selected;
    },
    updateItems(items) {
        // log('updateItems', items);
        this.setData({ tags: [] });
        if (this.alpha) {
            this.alphaItems(items);
        } else {
            const oldItems = this.getData().items || [];
            items.forEach((gitem, gindex) => {
                if (gindex < oldItems.length && gitem.type === 'swiper' && gitem.type === oldItems[gindex].type) {
                    gitem.items.forEach((item, index) => {
                        if (index < oldItems[gindex].items.length && item.url === oldItems[gindex].items[index].url) {
                            Object.assign(item, oldItems[gindex].items[index]);
                        }
                    });
                }
            });

            this.setData({ items });
            this.updateSelected(items);
        }
    },
    updateSelected(items) {
        // if (this.checkType !== '') {
        items || (items = this.getData().items);
        this.selected = [];
        items.forEach((gitem, gindex) => {
            if (this.createEmbedComponent && gitem.header && gitem.header.columns && gitem.header.columns.length > 0) {
                gitem.header.columns.forEach((column) => {
                    this.createEmbedComponent(column, gindex, undefined, gitem);
                });
            }
            if (this.createEmbedComponent && gitem.footer && gitem.footer.columns && gitem.footer.columns.length > 0) {
                gitem.footer.columns.forEach((column) => {
                    this.createEmbedComponent(column, gindex, undefined, gitem);
                });
            }
            if (this.createEmbedComponent && gitem.header) {
                this.createEmbedComponent(null, gindex, undefined, gitem.header);
            }
            if (this.createEmbedComponent && gitem.footer) {
                this.createEmbedComponent(null, gindex, undefined, gitem.footer);
            }
            this.createEmbedComponent(null, gindex, undefined, gitem);
            gitem.items &&
                gitem.items.forEach((item, index) => {
                    if (item.columns) {
                        item.columns.forEach((column) => {
                            this.createEmbedComponent(column, gindex, index, item);
                        });
                    }

                    if (item.checked) {
                        this.selected.push([ gindex, index ]);
                    }
                });
        });
        // }
    }
};
