import { followpanel, footer, list, loading, newmsgbutton, panelpicker, toptips } from '../polaris/polaris';

import Component from '../components/component';
import config from '../config/config';
import editColumnMixin from './editColumnMixin';
import { fixedEncodeURIComponent } from '../utils/utils';
import initFilter from '../module/initFilter';
import isString from '../lib/lodash/isString';
import log from '../utils/log';
import { login } from '../redux/login';
import mixin from '../utils/mixin';
// import regeneratorRuntime from '../lib/regenerator-runtime/runtime';
import requestMixin from './requestMixin';
import touchDirectionMixin from './touchDirectionMixin';
import { updateFilter } from '../redux/filter';
import { updateParams } from '../redux/params';
import { compareVersion } from '../utils/utils';
import * as request from '../utils/request';
import fetchCacheMixin from './fetchCacheMixin';

const CommonPageMixin = mixin(Component, [
    requestMixin,
    touchDirectionMixin,
    editColumnMixin,
    fetchCacheMixin,
    {
        reduxState: [ 'login', 'user'   ],
        mustLogin: false,
        isLogged() {
            return this.redux.user && this.redux.user.UserId && this.redux.user.XingMing !== '匿名';
        },
        getSystemInfo(infos) {
            if (!infos) {
                infos = [ 'windowHeight' ];
            }
            const data = {};
            dd.getSystemInfo({
                success: (res) => {
                    infos.forEach((key) => (data[key] = res[key]));
                    this.setData(data);
                }
            });
        },
        onShow() {
            


            if (this.mustLogin && !this.isLogged()) {
                this.handleLogin();
            }
        },
        redux: {},
        reduxDispatch: {
            loginAction: login,
            updateParams,
            updateFilter
        },
        components: {
            newmsgbutton,
            loading,
            panelpicker,
            toptips,
            followpanel,
            list,
            footer: {
                component: footer,
                options() {
                    return {
                        extendModeButtons: this.extendModeButtons.bind(this),
                        updateButtons: this.updateButtons.bind(this)
                    };
                }
            }
        },
        updateRedux({ setting, login, user   }) {

           // if (filter){
           //    let ks = Object.keys(filter);
           //    const regKs =/^\d+$/ig;
           //    if (ks.length>0 && regKs.test(ks[0]) && !this.pagePropertyUpdate){
           //          this.pagePropertyUpdate = true;
           //          this.coms.list.refresh();
           //    }
           // }



            if (setting != this.redux.setting) {
                this.coms.footer &&
                    setTimeout(() => {
                        this.coms.footer.switchExtendMode();
                    }, 10);
            }
        },
        initPageOps: [],
        initedPageOps: null,
        afterPageInited() {},
        appendInitPageOps(action) {
            if (this.initPageOps.findIndex((o) => o === action) < 0) {
                this.initPageOps = this.initPageOps.concat([ action ]);
            }
        },
        runAfterPageInited(op, data) {
            if (this.initPageOps.findIndex((o) => o === op) > -1) {
                this.initedPageOps || (this.initedPageOps = {});
                this.initedPageOps[op] = data;

                if (this.initPageOps.length === Object.keys(this.initedPageOps).length) {
                    // this.emit('hideLoading', this.page);
                    // this.clog('runAfterPageInited ok', op, data, this.initPageOps, this.initedPageOps);
                    this.afterPageInited(this.initedPageOps);
                } else {
                    // this.clog('runAfterPageInited', op, data, this.initPageOps, this.initedPageOps);
                }
            }
        },
        isFetchReq: false,
        fetchReq(reqs, callback) {
            if (this.isFetchReq === false) {
                reqs = reqs.map((req) => {
                    const params = req.params;
                    return request[req.req](params);
                });
                this.isFetchReq = true;
                return this.runAsync2(reqs, () => {
                    this.isFetchReq = false;
                }).then((data) => {
                    this.isFetchReq = false;
                    callback && callback(data);
                    return data;
                });
            }
        },
        // 用于更新操作，刷新数据用runAsync2或者包装的fetchReq
        emitReq(req, params, callback, messages) {
            messages = Object.assign(
                { success: '操作已成功完成', prompt: req === 'fakeDel' ? '确认删除数据吗?' : null },
                messages || {}
            );
            this.emit('req', this.page, req, params, callback, messages.valid, messages.prompt, messages.success);
        },
        emitReqRefresh(req, params, callback, messages, updateData) {
            this.emitReq(
                req,
                params,
                (ret) => {
                    let deleteData = null;

                    if (req === 'fakeDel') {
                        deleteData = toArray(params.ids);
                    }

                    const router = config.router[this.getOption('pageId')] || {};
                    const viewRouter = config.router[this.getOption('viewPageId')] || {};
                    const myIdColumn = router.myIdColumn || router.idColumn || viewRouter.idColumn;
                    this.emit('refresh_data', myIdColumn ? null : this.page, myIdColumn, updateData, deleteData);
                    callback && callback(ret);
                },
                messages
            );
        },
        emitFakeDel(ids) {
            this.emitReqRefresh('fakeDel', { categoryId: this.getOption('categoryId'), ids });
        },
        methods: {
            moreButtonClicked(button, item, gindex, index) {
                if (button.router || button.pageId) {
                    this.itemNav(button);
                }
            },

            handleLogin(extra) {
                console.log('handleLogin');
                this.emit('showAuth', this.page, {
                    extra,
                    callback: () => {
                        this.emit('refreshColumns');
                        this.onFirstShow();
                    }
                });
            },
            isLogged() {
                return this.redux.user && this.redux.user.UserId && this.redux.user.XingMing !== '匿名';
            },
            checkForLogin(callback) {
                console.log('checkForLogin');
                this.emit('showAuth', this.page, {
                    onlyFun: true,
                    callback
                });
            }
        },
        extendModeButtons(button) {
            return [];
        },
        handleRefreshEvent() {
            wx.stopPullDownRefresh();
        },
        handleButtonEvent(scope, button, item, gindex, index) {
            if (button) {
                if (isString(button)) {
                    button = {
                        id: button
                    };
                }
                this.moreButtonClicked(button, item, gindex, index);
            }
        },
        onLoad() {
            this.on('onPullDownRefresh', this.handleRefreshEvent);
            this.on('buttonClick', this.handleButtonEvent);
            initFilter(this.redux.updateFilter, this.getOption('pageId'));


            if (this.coms.filtab){
                console.log(this.coms.filtab.filter);
              this.setData({ pageConfig: this.coms.filtab.filter.pageConfig   });
            }

            console.log(this.options);




            const title = this.getOption('title');
            if (title) {
              //  wx.setNavigationBarTitle({ title });
            }

            dd.setNavigationBar({
             backgroundColor: config.primaryColor
           });





            if (config.primaryColor
            && this.options.router
            && ( this.options.router.indexOf('editdata')>0
            ||   this.options.router.indexOf('listdata')>0
            ||   this.options.router.indexOf('viewdata')>0
             )
            ){

              dd.setNavigationBar({
               title:  title ,
               backgroundColor: config.primaryColor,
               borderBottomColor:  config.primaryColor
             });





                // wx.setNavigationBarColor({
                //   frontColor: '#ffffff',
                //   backgroundColor: config.primaryColor
                // });
            }

        },
        updateButtons() {
            const buttons = [];
            return buttons;
        }
    }
]);

export default CommonPageMixin;
