import config from '../config/config';
import log from '../utils/log';

export default {
    data: {
        coms: {}
    },
    reduxState: [ 'cuser', 'filter' ],
    filter: {},
    columns: [],
    onlyThisCagegory: true,
    parentKey: {},
    updateRedux({ filter }) {
        const pageId = this.getOption('pageId');
        const theFilter = filter[pageId];
        this.allFilter = filter;



        if (theFilter && theFilter.display && theFilter !== this.filter) {
            log('当前字段信息', pageId, theFilter);
            this.filter = theFilter;
            this.refreshColumnInfos();
        }
    },
    filterColumns(pageId, filter, includeKey, excludeKey) {

     

        const includes = this[includeKey] || (config.router[pageId] && config.router[pageId][includeKey]) || [];
        let columns;
        if (includes.length > 0) {
            columns = filter.display.filter((item) => includes.findIndex((a) => a === item.ID) >= 0);
        } else {
            const excludes = this[excludeKey] || (config.router[pageId] && config.router[pageId][excludeKey]) || [];
            columns = filter.display.filter((item) => !item.isIndex && excludes.findIndex((a) => a === item.ID) < 0);
        }
        columns = columns.filter(
            (c) =>
                ((c.editType !== 'link' && (!this.forEdit || c.categoryId === filter.pageConfig.page.categoryId)) ||
                    (c.join && this.forEdit)) &&
                (!this.onlyThisCagegory || c.categoryId === filter.pageConfig.page.categoryId)
        );

        //查找所有联动关联的最末结点
        const linkColumns = columns.filter(
            (f) =>
                f.statusGroup &&
                f.statusGroup.depth > 0 &&
                !filter.display.find((c) => c.statusGroup && c.statusGroup.depth == f.ID)
        );

        // 生成联动关联的链
        const linkChain = [];
        linkColumns.forEach((l) => {
            const ll = [ l ];
            let ss = l;
            const find = (f) => f.ID === ss.statusGroup.depth;
            while (ss && ss.statusGroup.depth) {
                ss = filter.display.find(find);
                if (ss) {
                    ll.unshift(ss);
                }
            }
            const parent = Object.assign({ linkChain: ll }, ll[0]);
            let tp = parent;
            for (let ii = 1; ii < ll.length; ii++) {
                tp.child = Object.assign({ ancestor: tp.ID }, ll[ii]);
                tp = tp.child;
            }
            linkChain.push(parent);
        });

        // 需要展示的联动项，只显示根结点
        const needLink = [];
        let need = [];
        for (let ii = 0; ii < linkChain.length; ii++) {
            const lc = linkChain[ii];
            for (let jj = 0; jj < lc.linkChain.length; jj++) {
                const l = lc.linkChain[jj];
                if (columns.find((f) => f.ID === l.ID)) {
                    need = need.concat(lc.linkChain);
                    needLink.push(lc);
                    break;
                }
            }
        }

        columns = needLink.concat(columns.filter((f) => !need.find((t) => t.ID === f.ID)));

        const tagS = this.getOption('smartTagSource');
        const tagDes = this.getOption('smartTagDes');
        if (tagS && tagDes) {
            columns = columns.map((c) => {
                if (c.eid === tagS) {
                    return Object.assign({}, c, { smartTagSource: true });
                } else {
                    return c;
                }
            });
        }




        return this.customColumnInfo
            ? columns.map((column) => {
                  const newColumn = Object.assign({}, column);
                  this.customColumnInfo && this.customColumnInfo(newColumn);
                  return newColumn;
              })
            : columns;
    },
    _refreshColumnInfos() {
        const pageId = this.getOption('pageId');
        this.columns = this.filterColumns(pageId, this.filter, 'includes', 'excludes');
        // this.configColumns = this.columns;
        // const { sortedShow } = configFilter(this.configColumns, this.pageConfig.display);
        // this.sortedShow = sortedShow;

        return this.columns;
    },
    refreshColumnInfos() {
        // this.filter.display = this.filter.display.map((column) => {
        //   const newColumn = Object.assign({}, column);
        //   this.customColumnInfo && this.customColumnInfo(newColumn);
        //   this.createEmbedComponent && this.createEmbedComponent(newColumn);
        //   return newColumn;
        // });
        // const pageId = this.getOption('pageId');
        // const includes = this.includes || config.router[pageId] && config.router[pageId].includes || [];
        // if (includes.length > 0) {
        //   this.columns = this.filter.display.filter(item => includes.findIndex(a => a === item.ID) >= 0);
        // } else {
        //   const excludes = this.excludes || config.router[pageId] && config.router[pageId].excludes || [];
        //   this.columns = this.filter.display.filter(item => !item.isIndex && item.editType !== 'location' && excludes.findIndex(a => a === item.ID) < 0);
        // }

        this._refreshColumnInfos();
        this.setData({
            columns: this.columns
        });
        if (this.coms.list) {
            this.coms.list.filter = this.filter;
        }
        this.afterSetColumns && this.afterSetColumns();
    }
};
