import { fetchCache } from '../redux/cache';

export default {
    reduxState: [ 'cache' ],
    reduxDispatch: { fetchCache },
    cacheDataLoadCnt: 0,
    fromCache: true,
    fetchingCache: false,
    fetchCache(jobs) {
        if (!this.fetchingCache) {
            this.fetchingCache = true;
            this.redux.fetchCache({
                pageId: this.getOption('cacheKey'),
                jobs
            });
        }
    },
    propsToStateCompose: [
        {
            props: [ 'cache' ],
            transform(nextProps, preProps, newState) {
                const cacheKey = this.getOption('cacheKey');
                if (cacheKey) {
                    this.appendInitPageOps('cache');
                    const cacheData = nextProps.cache[cacheKey];
                    if (cacheData && cacheData !== this.cacheData) {
                        this.cacheData = cacheData;
                        if (this.cacheData.fetching) {
                            if (this.cacheDataLoadCnt > 1 || !this.cacheData.data) {
                                this.emit('showLoading', this.page);
                            }
                        } else if (this.cacheData.error && this.fetchingCache) {
                            this.fetchingCache = false;
                            this.commonErrorMsg(this.cacheData.error);
                            this.cacheDataLoadCnt++;
                        } else {
                            this.emit('hideLoading', this.page);
                            this.fetchingCache = false;
                            this.cacheDataLoadCnt++;
                            if (this.cacheData.data) {
                                this.runAfterPageInited('cache', this.fromCache);
                            }
                        }
                    }
                    this.fromCache = false;
                }
            }
        }
    ]
};
