// 列表刷新功能

import { alphaItems, toArray } from '../utils/utils';
import { fetchList, fetchListSuccess } from '../redux/list';

import config from '../config/config';
import log from '../utils/log';
import immutable from '../lib/seamless-immutable/src/seamless-immutable';

export default {
    reduxState: [ 'listData' ],
    reduxDispatch: { fetchListAction: fetchList, fetchListSuccess },
    lsc: [],
    fixedLsc: [],
    fetching: false,
    error: null,
    index: 1,
    loaded: false,
    displayCol: '',
    pageInfo: {},
    columns: {},
    cuser: {},
    listData: {},
    setFixedLsc(lsc) {
        this.fixedLsc = toArray(lsc) || [];
    },
    updateLsc(lsc) {
        this.lsc = toArray(lsc) || [];
    },
    refresh() {
        this.fetch(1);
    },
    fetchMore() {

        if (this.loaded === false) {
            this.fetch(this.index);
        }
    },
    alphaItems(items) {
        if (this.alpha) {
            const newItems = [];
            if (items.length > 0) {
                newItems.push(...items[0].items);
            }

            const result = alphaItems(newItems);

            this.setData(result);
            this.updateSelected(result.items);
        }
    },
    appendData(items, oldData, customModifyItem) {
        const newData = {};
        oldData = immutable(oldData);
        items.forEach((item, index) => {
            let gindex = 0;
            if (item.section) {
                gindex = oldData.findIndex((s) => s.ID === item.section.ID);
                if (gindex < 0) {
                    gindex = oldData.length;
                    oldData = oldData.concat([ Object.assign({}, item.section, { items: [] }) ]);
                    newData[`items[${gindex}]`] = item.section;
                }
            } else if (oldData.length === 0) {
                newData[`items[${gindex}]`] = { items: [] };
                oldData = oldData.concat({ items: [] });
            }
            const children = item.items ? item.items : [ item ];
            children.forEach((c) => {
                const ac = immutable(Object.assign({}, c, { section: undefined }));
                let iindex = oldData[gindex].items.length;
                oldData = oldData.map((gitem, gi) => {
                    if (gi == gindex) {
                        return gitem.merge({ items: gitem.items.concat([ ac ]) });
                    } else {
                        return gitem;
                    }
                });
                newData[`items[${gindex}].items[${iindex}]`] = ac;
                customModifyItem && customModifyItem(newData, ac, gindex, iindex);
            });
        });

       
        this.setData(newData);
        this.updateSelected(oldData);
    },
    updateRedux(nextProps) {
        const { listData } = nextProps;
        if (this.getOption('useFetch') === false) {
            return;
        }

        const pageId = this.getOption('pageId');
        const theData = listData[pageId];
        if (theData && theData !== this.listData && theData.index === this.index) {
            this.listData = theData;
            if (theData.fetching) {
                this.emit('showLoading', this.page);
            } else if (theData.error) {
                this.emit('hideLoading', this.page, '加载数据失败,请稍后重试');
                this.emit('refreshEnd', this.page);
                this.fetching = false;
            } else {
                log('当前列表数据', 'pageId', pageId, 'index', this.index, theData);
                this.emit('hideLoading', this.page);
                const fetchSize = this.getOption('fetchSize') > 0 ? this.getOption('fetchSize') : config.fetchSize;
                let oldData = this.getData().items || immutable([]);
                let items = theData.data;
                // 真实获取的数据数量，不包括preFeedData，preFeedData2，mockData
                let fetchedCount = this.getData().count || 0;
                fetchedCount += items.length;
                const curCount = items.length;
                if (this.index === 1) {
                    fetchedCount = items.length;

                    this.setData({
                        items: [],
                        tags: []
                    });

                    if (this.mockData) {
                        const mockData = this.mockData();
                        mockData.forEach((item) => this.customModifyItem(item));
                        items = items.concat(mockData);
                    }

                    // 一维数组，自动根据section找到对应的分组

                    if (this.preFeedData) {
                        const preItems = this.preFeedData();
                        items = items.concat(preItems);
                    }

                    // 二维数组，已处理过的数据
                    if (this.preFeedData2) {
                        const preItems = this.preFeedData2();
                        oldData = immutable(preItems);
                        this.setData({
                            items: oldData
                        });
                    } else {
                        oldData = immutable([]);
                    }
                    //  this.preFeedData && this.preFeedData(oldData); // 上部固定不变的数据，需要维护oldData，因为setData有延时
                    this.selected = [];
                }


                this.customModifyItems && (items = this.customModifyItems(items, oldData.length));
                if (items.length > 0) {
                    this.index += 1;
                    if (this.alpha) {
                        const newItems = [];
                        newItems.push(...items);
                        for (let ii = 0; ii < oldData.length; ii += 1) {
                            const items = oldData[ii].items;
                            newItems.push(...items);
                        }
                        this.alphaItems([ { items: newItems } ]);
                    } else {
                        this.appendData(items, oldData);
                    }
                }
                this.loaded = curCount < fetchSize;
                this.setData({
                    loading: false,
                    loaded: this.loaded,
                    count: fetchedCount
                });
                this.emit('refreshEnd', this.page, this.loaded);
                this.fetching = false;
            }
        }
    },
    fetch(index) {
        if (this.getOption('useFetch') === false) {
            return;
        }
        const pageId = this.getOption('pageId');
        if (this.fetching === false && pageId) {
            this.fetching = true;
            this.index = index;
            const lsc = [].concat(this.fixedLsc);
            lsc.push(...this.lsc);

            const fetchSize = this.getOption('fetchSize') > 0 ? this.getOption('fetchSize') : config.fetchSize;
            const categoryId = this.getOption('categoryId');

            this.redux.fetchListAction({
                categoryId,
                pageId,
                lsc,
                index,
                fetchSize,
                displayCol: this.displayCol,
                customModifyItem: this.customModifyItem && this.customModifyItem.bind(this)
            });
        }
    },
    onUnload() {
        const pageId = this.getOption('pageId');
        if (pageId && pageId > 0) {
            this.redux.fetchListSuccess({ pageId, index: -1, data: [] });
        }
    }
};
