export default {
  px2rpx: 2,
  windowWidth: 375,
  methods: {
    handleLoad(e) {
      const { gindex, index, sizeclass } = e.currentTarget.dataset;
      const originWidth = e.detail.width* this.px2rpx;
      const originHeight = e.detail.height* this.px2rpx;

      let fixHeight;
      if (sizeclass === 'height-large-square') {
        fixHeight = 750;
      } else if (sizeclass === 'height-large-ultra-wide') {
        fixHeight = 200;
      } else if (sizeclass === 'height-large-ultra-wide2') {
        fixHeight = 220;
      } else if (sizeclass === 'height-large-wide') {
        fixHeight = 480;
      } else if (sizeclass === 'height-large-wide-half') {
        fixHeight = 240;
      } else if (sizeclass === 'height-large-wide2') {
        fixHeight = 500;
      } else if (sizeclass === 'height-square-half') {
        fixHeight = 360;
      } else if (sizeclass === 'medium-square-height') {
        fixHeight = 335;
      }

      if (fixHeight) {
        const sizeHeight = 750.0 / originWidth * originHeight;
        // console.log(this);
        this.setData({
          loaded: true,
          originWidth,
          originHeight,
          imageHeight: (sizeHeight > fixHeight ? sizeHeight : fixHeight) / this.px2rpx
        }, `items[${gindex}].items[${index}]`);
      }
    }
  },
  onLoad:function(options){
    dd.getSystemInfo({
      success: (res) => {
        this.windowWidth = res.windowWidth;
        this.px2rpx = 750.0 / this.windowWidth;
      }
    })
  },
};
