import config from '../config/config';

export default {
  methods: {
    handleItemNav(e) {
      const { item } = e.currentTarget.dataset;
      this.itemNav(item);
    }
  },
  itemNav(item) {

    console.log(item);



    if (!item || item.noNav) {
      return false;
    }

    let nav = item.redirect ? this.redirectTo.bind(this) : this.navigateTo.bind(this);
     console.log(item.router);
    if (item.router) {
      const parts = item.router.match(/^(\d+)\?{0,1}/);
      if (parts && parts.length > 0) {
        const pageId = parts[1];
        const router = config.router[pageId] || {};
        if (router.router) {

          console.log(item.router.replace(parts[1], router.router));



          nav(item.router.replace(parts[1], router.router));
        } else {
          console.log('在config中没有找到该pageId的路由');
        }
        return true;
      }
      if (item.tab) {
        wx.switchTab({
          url: item.router
        });
      } else {
        nav(item.router, item.params);
      }
      return true;
    }

    const pageId = item.pageId || this.getOption('viewPageId') || item.viewPageId;

    if (!pageId ) {
      return false;
    }

    const editPageId = item.pageId ? 0 : this.getOption('editPageId');
    const editRouter = config.router[editPageId] || {};
    const editView = item.pageId ? '' : this.getOption('editView') || editRouter.router;
    const viewRouter = config.router[pageId] || {};



    let view;
    if (item.pageView) {
      view = item.pageView;
    } else if (viewRouter.router) {
      view = viewRouter.router;
      if (viewRouter.tab || viewRouter.redirect) {
        nav = this.redirectTo;
      }
    } else {
      view = this.getOption('viewView');
    }

    if (!view) {
      view = '';
      const pageType = item.pageType;
      // 15 创建 2 编辑 10 列表 22 列表查看 99 组合创建 100 组合编辑 101 组合查看 8 展示页（查看？）
      if (pageType == 15 || pageType == 2 || pageType === 100 || pageType === 99) {
        view = '/pages/editdata/index';
      } else if (pageType == 101 || pageType == 8 || pageType == 22) {
        view = '/pages/viewdata/index';
      } else if (pageType == 10 ) {
        view = '/pages/listdata/index';
      }
    }

    if (!view) {
      return false;
    }

    const router = config.router[this.getOption('pageId')] || {};
    let itemId = item.ID || item[router.idColumn] || item[viewRouter.idColumn];
    let server_identity = item.server_identity;

    if (viewRouter.tab  ) {
        dd.switchTab({
          url: viewRouter.router
        });
        return false;
    }  //ssong


    // if (!itemId && this.props.filter && this.props.filter.pageConfig) {
    //   const indexColumn = this.props.filter.pageConfig.columns.columns.find(c => c.isIndex);
    //   if (indexColumn) {
    //     itemId = item[indexColumn.eid];
    //   }
    // }

    const categoryId = item.categoryId || viewRouter.categoryId || this.getOption('categoryId');
    const params = item.params || {};

    console.log(params);

    nav(view, {
      itemId,
      server_identity,
      pageId,
      editPageId,
      editView,
      categoryId,
      ...params
    });

    return true;
  }
};
