import listMoreButtons from './listMoreButtons';

export default {
  selectMode: '',
  hasGrid: false,
  selectAll: true,
  methods: {
    moreButtonClicked(button) {
      if (button) {
        if (button.id === 'new') {
          this.handleCreateItem();
        } else if (button.id === 'grid') {
          this.redux.configSetting({ viewType: 'grid' });
        } else if (button.id === 'list') {
          this.redux.configSetting({ viewType: 'list' });
        } else if (button.id === 'enterSelect') {
          if (this.coms.list.checkType) {
            this.coms.list.setData({
              checkAnimate: false
            });
            this.coms.list.setCheckType('');
          } else {
            this.coms.list.setData({
              checkAnimate: true
            });
            this.coms.list.setCheckType(this.selectMode);
          }
        } else if (button.id === 'selectAll') {
          this.coms.list.checkAllItem(true);
          this.selectAll = false;
        } else if (button.id === 'unCheckAll') {
          this.coms.list.checkAllItem(false);
          this.selectAll = true;
        }
      }
    },
  },
  extendModeButtons(button) {
    return listMoreButtons.extendModeButtons(this, button);
  },
  updateButtons() {
    return listMoreButtons.updateButtons(this);
  }
};
