import * as request from '../utils/request';

import { loadUser } from '../redux/user';
import log from '../utils/log';
import { toArray, tryStrToJson, sequenceTasks } from '../utils/utils';

export default {
  reduxDispatch: { loadUser },
  checkValidData(req, data) {
    if ((req === 'fakeDel' || req === 'updateStatus') && (!data.ids || (Array.isArray(data.ids) && data.ids.length === 0))) {
      return false;
    }
    if (req === 'bulkCreate' && data.jsonStr.length === 0) {
      return false;
    }
    return true;
  },
  hackKeys(o) {
    const keys = Object.keys(o);
    keys.forEach(key=>{
      if (typeof o[key] === 'string') {
        const t = tryStrToJson(o[key]);
        if (t) {
          o[key] = t;
        }
      } else if (typeof o[key] === 'object' && o[key]) {
        this.hackKeys(o[key]);
      }
    })
  },
  __req(req, data, callback) {
    this.runAsync(() => {
      return request[req](data).then((ret) => {
        ret && this.hackKeys(ret);
        callback && callback(ret);
      });
    });
  },
  datareq(scope, req, data, callback, validMsg, promptMsg, successMsg) {
    const theCallback = (ret) => {
      if (successMsg) {
        this.emit('showToptip', this.page, { icon: 'success', text: successMsg });
      }
      callback && callback(ret);
    };
    if (this.checkValidData(req, data)) {
      if (promptMsg) {
        wx.showModal({
          title: '提示',
          content: promptMsg,
          success: (res) => {
            if (res.confirm) {
              this.__req(req, data, theCallback);
            }
          }
        });
      } else {
        this.__req(req, data, theCallback);
      }
    } else {
      this.emit('showToptip', this.page, { icon: 'warn', text: validMsg });
    }
  },
  onLoad() {
    this.on('req', this.datareq);
  },
  runAsync(job, failed) {
    this.emit('showLoading', this.page);
    job = toArray(job).map(j => {
      if (typeof j === 'function') {
        return j();
      } else {
        return j;
      }
    });

    return Promise.all(job).then((data) => {
      this.emit('hideLoading', this.page);
      return data.length === 1 ? data[0] : data;
    }).catch((error) => {
      if (failed && failed(error)) {
        return;
      }
      this.commonErrorMsg(error);
    });
  },
  runAsync2(job, failed, noLoading) {
    !noLoading && this.emit('showLoading', this.page);
    job = toArray(job).map(j => {
      if (typeof j === 'function') {
        return j;
      } else {
        return () => j;
      }
    });

    return sequenceTasks(job).then((data) => {
      this.emit('hideLoading', this.page);
      // console.log(data);
      return data.length === 1 ? data[0] : data;
    }).catch((error) => {
      if (failed && failed(error)) {
        return;
      }
      this.commonErrorMsg(error);
    });
  },
  commonErrorMsg(error) {
    log('error', error);
    if (error.code && error.message) {
      if (error.message.indexOf('登录超时') >= 0) {
        this.redux.loadUser({ XingMing: '匿名' });
      }
      this.emit('hideLoading', this.page, `${error.message},错误码${error.code}`);
    } else {
      this.emit('hideLoading', this.page, '操作失败,请稍后重试');
    }
  }
};
