export default {
  getTouchPosition(e) {
    if (e.changedTouches && e.changedTouches.length > 0) {
      return {
        x: e.changedTouches[0].pageX,
        y: e.changedTouches[0].pageY,
      };
    } else {
      return null;
    }
  },
  methods: {
    touchstart(e) {
      const p = this.getTouchPosition(e);
      if (p) {
        this.start = p;
      }
    },
    touchmove(e) {
      if (this.start) {
        const p = this.getTouchPosition(e);
        if (p) {
          const diffX = p.x - this.start.x;
          const diffY = p.y - this.start.y;
          this.emit('touchmove', this.page, { diffX, diffY });
        }
      }
    },
    touchend(e) {
      this.start = null;
      this.emit('touchend', this.page);
    }
  }
}
