import { fixImagePath } from '../../utils/utils';
import getPage from '../../module/page';
import { footer, filtab, list } from '../../polaris/polaris';
import mixin from '../../utils/mixin';
import request from '../../config/request';
import viewpage from '../../module/viewpage';
import listpage from '../../module/listpage';
import commonPage from '../../module/commonPage';
import { cache2 } from '../../utils/request';
import { login } from '../../redux/login';

const ActivityMixin = mixin(listpage,[{


  reduxState: [   'login', 'user','page' ],

        reduxDispatch: {
            loginAction: login
        },




  data: {
            url: ''
        },
  components: {
    list: {
        component: list,
        options() {
            return {

                customModifyItem(item) {
                    item.section = {
                      ID: 0,
                      type: 'list-image',
                      itemClass: 'padder-t-sm ',
                      class: 'padder-t-xxs  padder-b-sm'
                    };
                    item.primaryText = item.__c2;
                    item.secondaryText = item.__c8; // removeHtml(item.__c63);
                    item.tertiaryText = item.__c9;

                }
            };
        }
    },
    filtab: {
                  component: filtab,
                  options() {
                      return {
                          refreshColumns: true
                      };
                  }
    },

  },
    methods: {
       moreButtonClicked(button) {

          console.log(button);
          this.initData();

      },

  },
  initData(){
    dd.getSystemInfo({
        success: (res) => {
            var windowHeight = res.windowHeight;
            this.setData({
                scrollHeight: windowHeight
            });
        }
    });


      console.log(this.coms.filtab);



  },
  onLoad() {

     this.redux.loginAction({ server:'sa005', authCode:'mvcx002'});



      console.log('init page');

      this.initData();

      },

}]);

Page(getPage(ActivityMixin, {
   pageId: 3
}));
