import { formatDate, removeHtml } from '../../utils/utils';

import getPage from '../../module/page';
import { filtab, list } from '../../polaris/polaris';
import listpage from '../../module/listpage';
import mixin from '../../utils/mixin';
import request from '../../config/request';
import fetchListMixin from '../../module/fetchListMixin';

const ActivitylistMixin = mixin(listpage, [
  fetchListMixin,{
    data: {
       topUrl:'https://file8.mvcx.net/files/2028/201794/c5bedbe7-303e-47a3-8199-1705e4e807ac.jpg'
    },
  components: {
    filtab: {
                  component: filtab,
                  options() {
                      return {
                          refreshColumns: true
                      };
                  }
    },
    list: {
      component: list,
      options() {
        return {
          customModifyItem(item) {



            item.section = {
              ID: 0,
              imageLeft: true,
              type: 'list-image',

              class: ''
            };
            Object.assign(item, {
              url: [item.__c435.FilePath?item.__c435.FilePath:'/images/loading.png'],
              class: 'padder  padder-t-half padder-b-half b-b ',
              imageClass: 'height-large-ultra-wide',
              primaryText: item.__c41,
              secondaryText: `类目 : ${item.__c2}` ,
              secondaryText1: `款型 : ${item.__c37}` ,
              tertiaryText: `$:${item.__c35?item.__c35:''}`
            });
          }
        };
      }
    }
  },
  onLoad() {

    const sections =[];

    sections.push({
      ID: 's6',
      type: 'swiper',
      decorate: true,
      sizeClass: 'height-large-wide-half',
      fullMask: true,
      textClass: 'bg-black-opacity-lt',
      items: [ { url: 'https://file8.mvcx.net/files/2028/201794/c5bedbe7-303e-47a3-8199-1705e4e807ac.jpg'}]
    });

   //     this.coms.list2.updateItems(sections);

    //  this.coms.list.refresh();









  }
}]);

Page(getPage(ActivitylistMixin, {
  pageId: 20
}));
