import getPage from '../../module/page';
import list from '../../polaris/list/list';
import listpage from '../../module/listpage';
import log from '../../utils/log'
import mixin from '../../utils/mixin';
import request from '../../config/request';

const AddressMixin = mixin(listpage, [{
  components: {
    list: {
      component: list,
      options() {
        return {
          customModifyItem(item) {
            item.section = {
              ID: 0,
              class: 'b-t'
            };
            Object.assign(item, {
              parts: [
                {
                  type: 'list-item',
                  primaryText: item.__c208,
                  secondaryText: item.__c209,
                  tertiaryText: item.__c212
                }, {
                  __c206: item.__c206,
                  data: Object.assign({}, item),
                  type: 'footer4',
                  class: 'm-b-sm bg-white',
                  checks: [
                    {
                      id: item.__c215.ID == 564 ? '' : 'setDefault',
                      checked: item.__c215.ID == 564,
                      label: item.__c215.ID == 564 ? '默认地址' : '设为默认地址'
                    }
                  ],
                  buttons: [
                    {
                      id: 'delete',
                      label: '删除'
                    }
                  ]
                }
              ]
            });
          }
        };
      }
    }
  },
  methods: {
    moreButtonClicked(button, data) {
      let items = data ? [data] : this.coms.list.getSelectedItems();
      if (button.id === 'delete') {
        request.deleteAddress(this, items, ()=>{
          this.redux.configSetting({ defaultAddress: null });
        });
      } else if (button.id === 'setDefault') {
        request.defaultAddress(this, items[0], ()=>{
          this.redux.configSetting({ defaultAddress: items[0].data });
        });
      }
    }
  },
}]);

Page(getPage(AddressMixin, {
  pageId: 132
}));
