import { fixImagePath, formatDate, removeHtml } from '../../utils/utils';
import { list, swiper } from '../../polaris/polaris';

import getPage from '../../module/page';
import mixin from '../../utils/mixin';
import regeneratorRuntime from '../../lib/regenerator-runtime/runtime';
import request from '../../config/request';
import viewpage from '../../module/viewpage';

const ViewDataMixin = mixin(viewpage, [
    {
        components: {
            swiper: {
                component: swiper,
                options() {
                    return {
                        data: {
                            sizeClass: 'height-large-square'
                        }
                    };
                }
            },
            list: {
                component: list
            }
        },
        afterDetailFetched() {
            const item = this.detailData.data || {};
            // item.__c6 = formatDate(item.__c6, 'yyyy年MM月dd日');
            item.__c139 = removeHtml(item.__c139);

            const section = [];

            section.push({
                ID: 0,
                type: 'swiper',
                items: [ { url: fixImagePath(item.__c140.FilePath) } ]
            });

            section.push({
                ID: 1,
                type: 'list-brand-header',
                class: 'padder-t-lg2 padder-b-sm bg-white',
                items: [
                    {
                        primaryText: item.__c137,
                        secondaryText: item.__c139,
                        decorate: true
                    }
                ]
            });

            section.push({
                ID: 2,
                type: 'image-full',
                class: 'padder-b-lg bg-white',
                itemClass: 'padder padder-t',
                items: item.__c141 && item.__c141.map((i) => ({ url: fixImagePath(i.FilePath) }))
            });

            section.push({
                ID: 3,
                type: 'grid-card',
                header: {
                    type: 'header4',
                    title: '产品推荐',
                    class: 'padder-b'
                },
                class: 'padder-half padder-t-md m-t-sm bg-white',
                items: item.related[0].list.map((i) =>
                    Object.assign(
                        {
                            url: fixImagePath(i.__c65.FilePath),
                            primaryText: i.__c61,
                            price: i.__c64,
                            pageId: 46
                        },
                        i
                    )
                )
            });

            section.push({
                ID: 4,
                type: 'image-overlay',
                decorate2: true,
                fullMask: true,
                sizeClass: 'height-large-ultra-wide',
                class: 'padder-t-sm',
                itemClass: 'm-n',
                items: [
                    {
                        url: 'https://file3.bizsaas.com/files/2028/2017721/c263204f-d5de-45b6-a39c-cee4845b75f9.JPG',
                        primaryText: '查看更多产品',
                        router: '/pages/goodsfilter/index',
                        params: {
                            lsc: [ { patternId: 79, val1: item.server_identity, pTypeId: 23, operation: 1 } ]
                        }
                    }
                ]
            });

            this.coms.list.updateItems(section);
        }
    }
]);

Page(getPage(ViewDataMixin));
