import { fixImagePath, formatDate, removeHtml } from '../../utils/utils';
import { list, tab } from '../../polaris/polaris';

import { dateStr } from '../../utils/dateUtils';
// import filterMixin from '../../module/filterMixin';
import getPage from '../../module/page';
import mixin from '../../utils/mixin';
import request from '../../config/request';
import signalr from '../../redux/signalr'
import viewpage from '../../module/viewpage';

import { cache2 } from '../../utils/request';

import storage from '../../utils/storage';
import { login } from '../../redux/login';





const CenterMixin = mixin(viewpage, [{
  components: {
    list: {
      component: list,
    },
    tab
  },
  reduxState: [ 'page'   ],
  onShow(){
      // if (this.subjects)
      // {
      //   this.tabContainer();
      // }
  },
  fetchOnEnter: false,
  mustLogin: true,

  onReady(){

  //    this.handleLogin();
  },
  onLoad(){


  },
  onShow() {

    cache2( 'cacheTime', '2013-01-01').then((ret)=>{
         getApp().cacheTime = ret.cachetime[0].cacheTime;
    });

    const baseTopMenu=[
          {
          label: '+业务跟进',
          url: '/images/quick_sign_in.png',
          labelClass : 'm-t-sm text-base text-white',
          pageId: 339
        },
        {
          label: '+待办',
          url: '/images/abc_btn_rating_star_on_mtrl_alpha.png',
          labelClass : 'm-t-sm text-base text-white',
          pageId: 508,

        }
        ,
        {
          label: '+费用报销',
          url: '/images/abc_btn_rating_star_off_mtrl_alpha.png',
          labelClass : 'm-t-sm text-base text-white',
          pageId: 1154,

        }
    ];

    const baseMidMenu=[
      {
        label: '客户跟进',
        url: '/images/vv6.png',
        labelClass:'text-base m-t overflow-hidden',
        imageClass:'img-25-25 r-2x',
        pageId: 3,
      }
      ,
      {
        label: '货源',
        url: '/images/vv3.png',
        labelClass:'text-base m-t overflow-hidden',
        imageClass:'img-25-25 r-2x',
        pageId: 411,
      },
      {
        label: '应收款',
        url: '/images/vv2.png',
        labelClass:'text-base m-t overflow-hidden',
        imageClass:'img-25-25 r-2x',
        pageId: 'goods',
      }
      ,
      {
        label: '应付款',
        url: '/images/tongxin.png',
        labelClass:'text-base m-t overflow-hidden',
        imageClass:'img-25-25 r-2x',
        pageId: 59,
      },
      {
        label: '产品库',
        url: '/images/vv5.png',
        labelClass:'text-base m-t overflow-hidden',
        imageClass:'img-25-25 r-2x',
        pageId: '28',
      }
      ,
      {
        label: '开票',
        url: '/images/tongxin.png',
        labelClass:'text-base m-t overflow-hidden',
        imageClass:'img-25-25 r-2x',
          pageId: 251,
      },
      {
        label: '费用单据',
        url: '/images/vv1.png',
        labelClass:'text-base m-t overflow-hidden',
        imageClass:'img-25-25 r-2x',
        pageId: 290 ,
      },
      {
        label: '统计分析',
        url: '/images/tongji.png',
        labelClass:'text-base m-t overflow-hidden',
        imageClass:'img-25-25 r-2x',
             pageId: 80000,

      },
      {
        label: '质检单',
        url: '/images/vv3.png',
        labelClass:'text-base m-t overflow-hidden',
        imageClass:'img-25-25 r-2x',
        pageId: 75,
      }
      ,
      {
        label: '寄样单',
        url: '/images/vv4.png',
        labelClass:'text-base m-t overflow-hidden',
        imageClass:'img-25-25 r-2x',
        pageId: 379,
      },
      {
        label: '打样单',
        url: '/images/tongxin.png',
        labelClass:'text-base m-t overflow-hidden',
        imageClass:'img-25-25 r-2x',
        pageId: 395,
      },
      {
        label: '待办事项',
        url: '/images/vv5.png',
        labelClass:'text-base m-t overflow-hidden',
        imageClass:'img-25-25 r-2x',
        pageId: 510,
      }

   ];


    const sections = [];
    if (this.redux.page && this.redux.page.data){

      const  udfPages = this.redux.page.data.filter(x=>x.pageProperty && x.pageProperty.mobile);

      const  topMenus = udfPages.filter(x=>x.pageType==15|| x.pageType==99).map(i=>{
           return {
               label: i.UIname,
               url: '/images/abc_btn_rating_star_off_mtrl_alpha.png',
               labelClass : 'm-t-sm text-base text-white',
               pageId: i.ID,
               pageType:i.pageType
           }
       });

       let mergeTopMenus =[];
       let mergeMidMenus=[];

       console.log(topMenus);

       if (topMenus.length<3){
         for (var k =0 ;k< 3 ;k++ ){

            if (k<topMenus.length){
              mergeTopMenus.push(topMenus[k]);
            } else{
              mergeTopMenus.push(baseTopMenu[k]);
            }
         }
       }else{
           mergeTopMenus = topMenus;
       }

        console.log(mergeTopMenus);


      sections.push(
        {
          ID: 1,
          type: 'grid',
          itemClass: 'col-xs-4 m-b-sm padder-v white',
          class: 'm-b-sm  bg-main ',
          items: mergeTopMenus
        });



       const  midMenus  =    udfPages.filter(x=>x.pageType==10).map(i=>{

              let pageObj ={
                categoryId:i.categoryId,
                 pageId: i.ID,
                 title: i.UIname,
                 router: '/pages/listdata/index',
              };

              if (i.pageProperty.createPageId){
                 pageObj = Object.assign(pageObj,{ createPageId : i.pageProperty.createPageId });
              }
              if (i.pageProperty.idColumn){
                pageObj = Object.assign(pageObj,{ idColumn : i.pageProperty.idColumn });
              }

              if (i.pageProperty.viewPageId){
                pageObj = Object.assign(pageObj,{ viewPageId : i.pageProperty.viewPageId });
              }





              return {
                  label: i.UIname,
                  url: '/images/work_sel.png',
                  labelClass:'text-base m-t overflow-hidden',
                  imageClass:'img-25-25 r-2x',
                  pageId: i.ID,
                  router: '/pages/listdata/index',
                  params:  pageObj,
                  pageType:i.pageType
              }
          });

          if (midMenus.length<12){
            for (var k =0 ;k< 12 ;k++ ){

               if (k<midMenus.length){
                 mergeMidMenus.push(midMenus[k]);
               } else{
                 mergeMidMenus.push(baseMidMenu[k]);
               }
            }
          }else{
              mergeMidMenus = midMenus;
          }




          sections.push(
             {
               ID:3,
               type: 'grid',
               class: 'bg-white',
               columnCount: 4,
               itemClass: 'padder-v b-b  b-r',
               items: mergeMidMenus

        });





      console.log(sections);
    }












    sections.push({
        ID:4,
        type:'list-item',
        header:{
          class:'m-t-sm'
        },
        items: [
          {
            icon:'fa fa-th-large',
            iconClass:'text-sm text-gray',
            primaryText: '使用说明',
            primaryClass: 'text-md  ',
            pageId: 'note'
          }
        ],
      });



      if (!this.dataList || this.dataList.length===0){
        this.dataList = [{_Key: "本月应收款", _Value: "0000",icon:'fa fa-star'},{_Key: "本月应付款", _Value: "0000",icon:'fa fa-bookmark-o'},
                    {_Key: "执行中订单", _Value: "0000",icon:'fa fa-bell-o'},{_Key: "总体业绩", _Value: "0000",icon:'fa fa-money'},
                    {_Key: "新增订单数", _Value: "0000",icon:'fa fa-laptop'},{_Key: "环比增幅", _Value: "0000",icon:'fa fa-cubes'},

                        ];
      }






      sections.push({
          ID:5,
          type:'grid-h',
          class:'bg-white padder-lg m-t-sm',
          columnCount: 2,
          items:   this.dataList.map(i => {   return {
              type: 'grid-h',
              class: 'padder-v-md padder',
              primaryText: i._Key,
              primaryClass: 'text-muted',
              icon: i.icon + ' primary-color text-lg',
              iconClass: '  padder-sm',
              imageContainer: 'b-r',
              secondaryText:  i._Value,
              secondaryClass: 'text-muted2'
            }

          })

        });





        this.coms.list.updateItems(sections);








  }

}]);

Page(getPage(CenterMixin));
