import { comment, footer, list, tab } from '../../polaris/polaris';
import { fixImagePath, removeHtml } from '../../utils/utils';

import fetchListMixin from '../../module/fetchListMixin';
import { formatDate } from '../../utils/dateUtils';
import getPage from '../../module/page';
import mixin from '../../utils/mixin';
import redux from '../../redux/index';
import request from '../../config/request';
import viewpage from '../../module/viewpage';

const DealerMixin = mixin(viewpage, [
    fetchListMixin,
    {
        fetchListOnEnter: false,
        components: {
            list3: {
                component: list,
                options() {
                    return {
                        data: {
                            noFoot: true
                        }
                    };
                }
            },
            list2: {
                component: list,
                options() {
                    return {
                        data: {
                            noFoot: true
                        }
                    };
                }
            },
            list: {
                component: list,
                options() {
                    return {
                        pageId: 34,
                        customModifyItem(item) {
                            item.section = {
                                ID: 5,
                                type: 'list-comment',
                                class: 'm-t-sm bg-white',
                                header: {
                                    type: 'header1',
                                    title: '用户评论',
                                    decorate: true,
                                    class: 'padder-t-md padder-b-sm'
                                }
                            };
                            item.user = item.__c52.XingMing;
                            item.time = formatDate(item.__c54, 'yyyy-MM-dd hh:mm:ss');
                            item.avatar =
                                'https://file3.bizsaas.com/files/2028/2017721/c263204f-d5de-45b6-a39c-cee4845b75f9.JPG';
                            item.content = removeHtml(item.__c53);
                        }
                    };
                }
            },
            tab,
            footer: {
                component: footer,
                options() {
                    return {
                        extendModeButtons: this.extendModeButtons.bind(this),
                        updateButtons: this.updateButtons.bind(this),
                        data: {
                            vertical: true,
                            flex: true,
                            bigButtons: [
                                {
                                    id: 'subscribe',
                                    label: '预约商家',
                                    class: 'btn-black w-50-b'
                                }
                            ]
                        }
                    };
                }
            },
            comment: {
                component: comment,
                options() {
                    return {
                        sendComment: this.sendComment.bind(this)
                    };
                }
            }
        },
        sendComment(comment) {
            request.comment(this, {
                __c240: this.getData().item.server_identity,
                __c53: comment
            });
        },
        methods: {
            moreButtonClicked(button, item) {
                if (button.id === 'comment') {
                    this.coms.comment.setVisible();
                } else if (button.id === 'subscribe') {
                    this.itemNav({
                        pageId: 70,
                        params: {
                            item: {
                                __c305: this.composeData[0][0].server_identity
                            }
                        }
                    });
                } else if (button.id === 'tel') {
                    wx.makePhoneCall({
                        phoneNumber: this.composeData[0][0].__c148
                    });
                } else if (button.id === 'attention') {
                    request.attention(
                        this,
                        {
                            __c309: this.redux.user.UserId,
                            __c313: this.composeData[0][0].server_identity
                        },
                        () => {
                            const idColumn = this.getOption('idColumn');
                            this.emit('refresh_data', null, idColumn, [
                                {
                                    __c309: this.redux.user,
                                    [idColumn]: this.composeData[0][0].ID
                                }
                            ]);
                        }
                    );
                }
            }
        },
        updateButtons() {
            return [
                {
                    id: 'tel',
                    label: '电话',
                    icon: 'icon-call-end'
                },
                {
                    id: 'comment',
                    label: '评论',
                    icon: 'icon-speech'
                }
            ];
        },
        customModifyItem(item) {
            // const item = this.detailData.data;
            Object.assign(this.composeData[0][0], item);

            const section = [];

            section.push({
                ID: 0,
                type: 'swiper',
                items: [
                    {
                        url: fixImagePath(this.composeData[0][0].__c253.FilePath)
                    }
                ]
            });

            section.push({
                ID: 1,
                type: 'list-dealer-header',
                class: 'padder-t-xs bg-white',
                itemClass: 'padder-b-md b-b',
                items: [
                    {
                        primaryText: this.composeData[0][0].__c153,
                        secondaryText: this.composeData[0][0].__c149,
                        attention: this.composeData[0][0].__c309 && this.composeData[0][0].__c309.UserId
                        // tertiaryText: '婚礼策划',
                        // quartusText: '关注 690'
                    }
                ]
            });

            section.push({
                ID: 2,
                type: 'list-item',
                items: [
                    {
                        primaryText: this.composeData[0][0].__c304,
                        subIcon: 'icon-call-end'
                    }
                ]
            });

            this.coms.list3.updateItems(section);

            /*this.coms.tab.setData({
      selectedId: 0,
      className: 'bg-white m-t-sm',
      lineClass: 'linef b-b',
      list: [
        {
          title: '主题',
          key: 'firstpage'
        },
        {
          title: '案例',
          key: 'case'
        },
        {
          title: '活动',
          key: 'set'
        },
        {
          title: '评价',
          key: 'comment'
        }
      ]
    });*/

            const section2 = [];

            section2.push({
                ID: 0,
                header: {
                    type: 'header2',
                    decorate: true,
                    class: 'b-b bg-white',
                    title: '主题',
                    subTitle: '更多',
                    subClass: 'text-muted-d text-xs2',
                    subIcon2: 'fa fa-angle-right'
                },
                type: 'image-overlay',
                sizeClass: 'height-large-wide',
                class: 'padder-b-lg2 m-t-sm bg-white',
                itemClass: 'padder padder-t padder-b-xs',
                items: this.composeData[1].map((item) => {
                    return { url: fixImagePath(item.__c82[0].FilePath), ID: item.ID, pageId: 54 };
                })
            });

            section2.push({
                ID: 1,
                type: 'grid-card',
                class: 'm-t-sm padder-b bg-white',
                header: {
                    type: 'header2',
                    decorate: true,
                    class: 'b-b bg-white',
                    title: '精美案例',
                    subTitle: '更多',
                    subClass: 'text-muted-d text-xs2',
                    subIcon2: 'fa fa-angle-right'
                },
                bodyClass: 'padder',
                items: this.composeData[2].map((item) => {
                    return {
                        ID: item.ID,
                        primaryText: item.__c243,
                        url: fixImagePath(item.__c247.FilePath),
                        imageClass: 'medium-height',
                        primaryClass: 'padder-xs m-t-sm2 text-sm',
                        class: 'col-xs-4 padder-t padder-r-q padder-l-q',
                        pageId: 161
                    };
                })
            });

            section2.push({
                ID: 1,
                type: 'list-image',
                class: 'm-t-sm bg-white',
                itemClass: 'b-b bg-white',
                imageLeft: true,
                header: {
                    type: 'header2',
                    decorate: true,
                    class: 'b-b bg-white',
                    title: '精选活动',
                    subTitle: '更多',
                    subClass: 'text-muted-d text-xs2',
                    subIcon2: 'fa fa-angle-right'
                },
                items: this.composeData[3].map((item) => {
                    return {
                        ID: item.ID,
                        pageId: 16,
                        primaryText: item.__c12,
                        url: [ fixImagePath(item.__c20.FilePath) ],
                        imageWrap: 'col-xs-4 no-padder',
                        imageClass: 'medium-height padder-r',
                        primaryClass: 'font-bold',
                        // price: 666,
                        priceClass: 'text-md2 font-bold text-danger'
                        // originalPrice: 999,
                        // tertiaryText: '999人收藏'
                    };
                })
            });

            this.coms.list2.updateItems(section2);
        },
        fetchDetail() {
            request.fetchDealer(this, this.getOption('itemId'), (data) => {
                this.composeData = data.data;

                this.customModifyItem();

                this.coms.list.setFixedLsc([
                    { patternId: 240, val1: this.composeData[0][0].server_identity, pTypeId: 23, operation: 1 }
                ]);
            });
        }
    }
]);

Page(
    getPage(DealerMixin, {
        pageId: 163
    })
);
