import listpage from '../../module/listpage';
import getPage from '../../module/page';
import { list } from '../../polaris/polaris';
import mixin from '../../utils/mixin';
import request from '../../config/request';
import { fixImagePath } from '../../utils/utils';

const DealerMixin = mixin(listpage, [{
  components: {
    list: {
      component: list,
      options() {
        return {
          customModifyItem(item) {
            item.section = {
              ID: 0,
              type: 'list-image',
              imageLeft: true,
              class: 'b-t'
            };
            item.url = item.__c152.map(i => fixImagePath(i.FilePath));
            item.primaryText = item.__c153;
            item.primaryClass= 'text-l-2 font-bold text-md2';
            item.secondaryText = `电话: ${item.__c148}`;
            item.secondaryClass = 'm-t-sm text-muted-d text-xs text-l-2';
            item.tertiaryText = `地址: ${item.__c304}`;
            item.tertiaryClass = 'm-t-half text-muted-d text-xs';
            item.imageWrap = 'padder-r w-35-b';
            item.imageClass = 'medium-height4';
          }
        }
      }
    }
  }
}]);

Page(getPage(DealerMixin, {
  pageId: 94
}));
