import getPage from '../../module/page';
import { list } from '../../polaris/polaris';
import listpage from '../../module/listpage';
import mixin from '../../utils/mixin';
import request from '../../config/request';

const FriendMixin = mixin(listpage, [{
  components: {
    list: {
      component: list,
      options() {
        return {
          moreButtons: [
            {
              id: 'post',
              label: '发送消息',
              icon: 'icon-star'
            },
            {
              id: 'delete',
              label: '删除',
              icon: 'icon-trash'
            }
          ]
        };
      }
    }
  },
  methods: {
    moreButtonClicked(button, data) {
      if (button.id === 'post') {
        this.navigateTo('/pages/message/editmessage', {
          pageId: 85,
          item: {
            __c120: Object.assign({ ID: data.__c15.UserId, primaryText: data.__c15.XingMing }, data.__c15)
          }
        });
      } else if (button.id === 'delete') {
        const items = data ? [data] : this.coms.list.getSelectedItems();
        request.deleteFriend(this, items);
      }
    }
  }
}]);

Page(getPage(FriendMixin, {
  pageId: 195
}));
