import { confirmFilter, updateSingleFilter } from '../../redux/filter';
import { filtab, list } from '../../polaris/polaris';
import { fixImagePath, removeHtml } from '../../utils/utils';
import filtab2 from '../../polaris/filtab/filtab2';
import filtpanel4 from '../../polaris/filtpanel/filtpanel4';

import component from '../../components/component';
import getPage from '../../module/page';
import listMoreButtons from '../../module/listMoreButtons';
import listpage from '../../module/listpage';
import mixin from '../../utils/mixin';
import request from '../../config/request';
import tabfilter from '../../polaris/tabfilter/tabfilter';

const goodsBtns = [
    {
        id: 'collect',
        label: '收藏',
        icon: 'icon-star'
    },
    {
        id: 'buy',
        label: '购买',
        icon: 'icon-basket'
    }
];

const GoodsMixin = mixin(listpage, [
    {
        mustLogin: true,
        reduxDispatch: { updateSingleFilter, confirmFilter },
        components: {
            // tabfilter: {
            //     component: tabfilter,
            //     options() {
            //         return {
            //             callback: this.handleRefreshEvent.bind(this)
            //         };
            //     }
            // },
            list: {
                component: list,
                options() {
                    return {
                        moreButtons: goodsBtns,
                        customModifyItem(item) {
                            item.section = {
                                ID: 0,
                                class: 'padder-half bg-white m-t'
                            };
                            item.primaryText = item.__c61;
                            item.secondaryText = item.__c328.statusName; // removeHtml(item.__c63);
                            item.tertiaryText = item.__c312 && item.__c312.map((i) => i.statusName).join(' ');
                            item.url = item.__c65.FilePath; // fixImagePath(item.__c65);
                            item.price = item.__c64;
                            item.tag = '新品';
                            item.tagImage = '/images/favor.png';
                            item.itemType = 'grid-card';
                            item.halfCross = true;
                        },
                        preFeedData() {
                            return [];
                            return [
                                {
                                    section: {
                                        ID: 112,
                                        class: 'pos-abt padder-half bg-white m-t',
                                        itemClass: 'pos-abt'
                                    },
                                    itemType: 'grid-buttons',
                                    buttons: [
                                        {
                                            id: 'filter',
                                            label: '完美婚纱',
                                            columnID: 74,
                                            statusMaps: [ { ID: 631 } ]
                                        },
                                        {
                                            id: 'filter',
                                            label: '晚礼服',
                                            columnID: 74,
                                            statusMaps: [ { ID: 635 } ]
                                        },
                                        {
                                            id: 'filter',
                                            label: '伴娘服',
                                            columnID: 74,
                                            statusMaps: [ { ID: 633 } ]
                                        },
                                        {
                                            id: 'filter',
                                            label: '酒会礼服',
                                            columnID: 74,
                                            statusMaps: [ { ID: 638 } ]
                                        },
                                        {
                                            id: 'filter',
                                            label: '亲子礼服',
                                            columnID: 74,
                                            statusMaps: [ { ID: 637 } ]
                                        },
                                        {
                                            id: 'filter',
                                            label: '小黑裙',
                                            columnID: 74,
                                            statusMaps: [ { ID: 641 } ]
                                        },
                                        {
                                            id: 'filter',
                                            label: '花童礼服',
                                            columnID: 74,
                                            statusMaps: [ { ID: 639 } ]
                                        },
                                        {
                                            id: 'filter',
                                            label: '毕业礼服',
                                            columnID: 74,
                                            statusMaps: [ { ID: 640 } ]
                                        }
                                    ]
                                }
                            ];
                        }
                    };
                }
            },
            filtab: {
                component: filtab2,
                options() {
                    return {
                        refreshColumns: true
                    };
                }
            },
            morefiltpanel: filtpanel4
        },
        methods: {
            moreButtonClicked(button, data) {
                const items = data ? [ data ] : this.coms.list.getSelectedItems();
                if (button.id === 'collect') {
                    request.collectGoods(this, items);
                } else if (button.id === 'buy') {
                    request.buyGoods(this, items);
                } else if (button.id === 'filter') {
                    this.redux.updateSingleFilter({
                        pageId: this.getOption('pageId'),
                        columnID: button.columnID,
                        items: button.statusMaps
                    });
                    this.redux.confirmFilter({ pageId: this.getOption('pageId') });
                }
            }
        },
        extendModeButtons(button) {
            const buttons = listMoreButtons.extendModeButtons(this, button);
            buttons.push(...goodsBtns);
            return buttons;
        }
    }
]);

Page(
    getPage(GoodsMixin, {
        pageId: 41
    })
);
