import { confirmFilter, updateSingleFilter } from '../../redux/filter';
import { filtab, list } from '../../polaris/polaris';
import { fixImagePath, removeHtml } from '../../utils/utils';
import filtab2 from '../../polaris/filtab/filtab2';
import filtpanel4 from '../../polaris/filtpanel/filtpanel4';

import component from '../../components/component';
import getPage from '../../module/page';
import listMoreButtons from '../../module/listMoreButtons';
import listpage from '../../module/listpage';
import mixin from '../../utils/mixin';
import request from '../../config/request';
import tabfilter from '../../polaris/tabfilter/tabfilter';


const GoodsMixin = mixin(listpage, [
    {
        mustLogin: true,
        reduxDispatch: { updateSingleFilter, confirmFilter },
        components: {

            list: {
                component: list,
                options() {
                    return {

                        customModifyItem(item) {
                            item.section = {
                                ID: 0,
                                class: 'padder-half bg-white m-t'
                            };
                            item.primaryText = item.__c61;
                            item.secondaryText = item.__c328.statusName; // removeHtml(item.__c63);
                            item.tertiaryText = item.__c312 && item.__c312.map((i) => i.statusName).join(' ');
                            item.url = item.__c65.FilePath; // fixImagePath(item.__c65);
                            item.price = item.__c64;
                            item.tag = '新品';
                            item.tagImage = '/images/favor.png';
                            item.itemType = 'grid-card';
                            item.halfCross = true;
                        } 
                    };
                }
            },
            filtab: {
                component: filtab2,
                options() {
                    return {
                        refreshColumns: true
                    };
                }
            },
            morefiltpanel: filtpanel4
        },
        methods: {
            moreButtonClicked(button, data) {

            }
        },

    }
]);

Page(
    getPage(GoodsMixin, {
        pageId: 41
    })
);
