import Component from '../../components/component';
import displayColumnMixin from '../../module/displayColumnMixin';
import editColumnMixin from '../../module/editColumnMixin';
import filterMixin from '../../module/filterMixin';
import mixin from '../../utils/mixin';
import { refreshItemDisplay } from '../../utils/utils';
import xnumber from '../../polaris/xnumber/xnumber';

export default mixin(Component, [filterMixin, displayColumnMixin, editColumnMixin,
  {
    includes: [197, 316, 317],
    refreshColumns: true,
    pageId: 116,
    data: {
      visible: false,
      item: {}
    },
    defaultShowCss: {
      back: 'fadeIn',
      main: 'slideInUp'
    },
    defaultHideCss: {
      back: 'fadeOut',
      main: 'slideOutDown'
    },
    methods: {
      handleOutTap(e) {
        this.setHidden();
      },
      handleConfirm(e) {
        this.emit('buyPanelReturn', this.page, this.getData().item);
        this.setHidden();
      }
    },
    onShowBuyPanel(scope, item) {
      let column = this.filter.display.find(i => i.ID === 316);
      column.statusMap = (item.__c77 || []).map(i => Object.assign({ primaryText: i.statusName }, i));
      column = this.filter.display.find(i => i.ID === 317);
      column.statusMap = (item.__c312 || []).map(i => Object.assign({ primaryText: i.statusName }, i));
      this.refreshColumnInfos();

      refreshItemDisplay(this.filter.display, this.redux.cuser.data, item, 'ord', true).then(()=>{
        this.setData({
          item
        });
        this.mergeInComing(item);
        this.setVisible();
      });
    },
    customColumnInfo(column) {
      if (column.ID == 197) {
        column.type = 'edit-number';
        column.component = {
          component: 'xnumber'
        };
      } else if (column.ID == 316) {
        column.type = 'edit-status2';
      } else if (column.ID == 317) {
        column.type = 'edit-status2';
      }
    },
    onLoad() {
      this.on('showBuyPanel', this.onShowBuyPanel);
    }
  }]
);
