import { fixImagePath, formatDate, removeHtml } from '../../utils/utils';
import { footer, list, swiper, tab } from '../../polaris/polaris';
import log, { mark } from '../../utils/log';

import buypanel from './buypanel';
import getPage from '../../module/page';
import mixin from '../../utils/mixin';
import regeneratorRuntime from '../../lib/regenerator-runtime/runtime';
import request from '../../config/request';
import { updateParams } from '../../redux/params';
import viewpage from '../../module/viewpage';

const GoodsDetailMixin = mixin(viewpage, [
    {
        reduxDispatch: { updateParams },
        components: {
            list: {
                component: list
            },
            buypanel,
            footer: {
                component: footer,
                options() {
                    return {
                        extendModeButtons: this.extendModeButtons.bind(this),
                        updateButtons: this.updateButtons.bind(this),
                        data: {
                            vertical: true,
                            bigButtons: [
                                {
                                    id: 'cart',
                                    label: '加入购物车',
                                    class: 'btn-default w-35-b no-border b-l'
                                },
                                {
                                    id: 'buynow',
                                    label: '立即预约'
                                }
                            ]
                        }
                    };
                }
            }
        },
        methods: {
            moreButtonClicked(button) {
                const item = this.getData().item;
                if (button.id === 'cart') {
                    this.goCart = false;
                    this.emit('showBuyPanel', this.page, Object.assign({ __c197: 1 }, item));
                } else if (button.id === 'buynow') {
                    this.itemNav({
                        pageId: 70,
                        params: {
                            item: {
                                // __c305: this.getData().item.server_identity
                            }
                        }
                    });
                    // this.goCart = true;
                    // this.emit('showBuyPanel', this.page, Object.assign({ __c197: 1 }, item));
                } else if (button.id === 'collect') {
                    const data = (this.composeData && this.composeData[1][0]) || {};
                    if (!data.__c202 || !data.__c202.UserId) {
                        request.collectGood(this, item, () => {
                            const idColumn = this.getOption('idColumn');
                            this.emit('refresh_data', null, idColumn, [
                                {
                                    __c202: this.redux.user,
                                    [idColumn]: data.ID
                                }
                            ]);
                        });
                    }
                }
            }
        },
        onBuyPanelReturn(scope, item) {
            // if (this.goCart) {
            //   this.redux.updateParams({ type: 'cart', data: [item] });
            //   this.navigateTo('/pages/settle/index');
            // } else {
            request.buyGood(this, item);
            // }
        },
        customModifyItem(item) {
            Object.assign(this.composeData[1][0], item);

            const header = [ { url: fixImagePath(this.composeData[1][0].__c65.FilePath) } ];
            this.composeData[1][0].__c70 &&
                this.composeData[1][0].__c70.forEach((i) => {
                    header.push({ url: fixImagePath(i.FilePath) });
                });
            const section = [];

            section.push({
                ID: 0,
                type: 'swiper',
                sizeClass: 'height-large-square',
                items: header
            });

            section.push({
                ID: 1,
                type: 'list-item',
                itemClass: 'padder-v-md',
                items: [
                    {
                        noNav: true,
                        primaryText: this.composeData[1][0].__c61,
                        primaryClass: 'text-lg2',
                        tertiaryText: `¥${this.composeData[1][0].__c64}`,
                        tertiaryClass: 'm-t text-lg2 font-bold text-black'
                    }
                ]
            });

            // section.push({
            //   ID: 2,
            //   type: 'list-item',
            //   class: 'm-t-sm',
            //   items: [{
            //     primaryText: '商品规格',
            //     secondaryText: ''
            //   }]
            // });

            section.push({
                ID: 3,
                type: 'list-item',
                class: 'm-t-sm',
                items: [
                    {
                        primaryText: '商品评价',
                        secondaryText: `${this.composeData[2][0].comment}评价`,
                        secondaryClass: 'text-black text-base',
                        pageId: 34,
                        params: {
                            lsc: [
                                {
                                    patternId: 58,
                                    val1: this.composeData[1][0].server_identity,
                                    pTypeId: 23,
                                    operation: 1
                                }
                            ]
                        }
                    }
                ]
            });

            section.push({
                ID: 4,
                type: 'list-image',
                class: 'm-t-sm',
                imageLeft: true,
                items: this.composeData[0].map((i) => ({
                    url: [ 'https://file3.bizsaas.com/files/2028/2017721/c263204f-d5de-45b6-a39c-cee4845b75f9.JPG' ],
                    primaryText: i.__c128,
                    secondaryText: i.__c131,
                    nav: true,
                    imageWrap: 'padder-r-sm2 w-30-b',
                    imageClass: 'medium-height4',
                    pageId: 16,
                    ID: i.ID
                }))
            });

            section.push({
                ID: 5,
                type: 'list-item2',
                class: 'm-t-sm padder-b bg-white',
                header: {
                    type: 'header2',
                    title: '商品介绍',
                    class: 'b-b bg-white',
                    titleClass: 'font-normal'
                },
                items: [
                    {
                        primaryText: '品牌',
                        secondaryText: this.composeData[1][0].__c137
                    },
                    {
                        primaryText: 'SKU',
                        secondaryText: this.composeData[1][0].__c62
                    },
                    {
                        primaryText: '分类',
                        secondaryText:
                            this.composeData[1][0].__c74 &&
                            this.composeData[1][0].__c74.statusName
                    },
                    {
                        primaryText: '场合',
                        secondaryText:
                            this.composeData[1][0].__c75 &&
                            this.composeData[1][0].__c75.statusName
                    },
                    {
                        primaryText: '款式',
                        secondaryText:
                            this.composeData[1][0].__c76 &&
                            this.composeData[1][0].__c76.map((i) => i.statusName).join(',')
                    },
                    {
                        primaryText: '颜色',
                        secondaryText:
                            this.composeData[1][0].__c77 &&
                            this.composeData[1][0].__c77.map((i) => i.statusName).join(',')
                    },
                    {
                        primaryText: '版型',
                        secondaryText:
                            this.composeData[1][0].__c78 &&
                            this.composeData[1][0].__c78.map((i) => i.statusName).join(',')
                    },
                    {
                        primaryText: '尺码',
                        secondaryText:
                            this.composeData[1][0].__c312 &&
                            this.composeData[1][0].__c312.map((i) => i.statusName).join(',')
                    }
                ]
            });

            section.push({
                ID: 6,
                type: 'image-full',
                header: {
                    parts: [
                        {
                            type: 'header1',
                            title: '继续拖动,查看图文详情',
                            class: 'bg-light',
                            titleClass: 'text-xs text-muted-d'
                        },
                        {
                            type: 'header2',
                            title: '图文详情',
                            titleClass: 'font-normal'
                        }
                    ]
                },
                itemClass: 'm-b-sm',
                items: this.composeData[1][0].__c70.map((i) => ({
                    url: fixImagePath(i.FilePath)
                }))
            });

            this.setData({
                item: this.composeData[1][0]
            });
            this.coms.list.updateItems(section);

            this.coms.footer.switchExtendMode();
        },
        fetchDetail() {
            request.fetchGoodsDetail(this, this.getOption('itemId'), (data) => {
                this.composeData = data.data;
                this.customModifyItem();
            });
        },
        updateButtons() {
            const data = (this.composeData && this.composeData[1][0]) || {};

            return [
                {
                    id: 'share',
                    label: '分享',
                    icon: 'icon-share'
                },
                {
                    id: 'collect',
                    label: '收藏',
                    icon: data.__c202 && data.__c202.UserId ? 'fa fa-heart' : 'fa fa-heart-o'
                }
            ];
        },
        onLoad() {
            this.on('buyPanelReturn', this.onBuyPanelReturn);
        },
        updateRedux({ detailData }) {
            // const commentTypes = [
            //   {
            //     id: 'all',
            //     title: '全部'
            //   },
            //   {
            //     id: 'good',
            //     title: '好评(99)'
            //   },
            //   {
            //     id: 'soso',
            //     title: '中评'
            //   },
            //   {
            //     id: 'bad',
            //     title: '差评'
            //   },
            //   {
            //     id: 'image',
            //     title: '有图'
            //   }
            // ];
            // this.coms.tab2.setData({
            //   list: commentTypes
            // });
            // this.updatePageInfo(commentTypes[0]);
        }
    }
]);

Page(
    getPage(GoodsDetailMixin, {
        pageId: 46
    })
);
