import { tab, list } from '../../polaris/polaris';

import getPage from '../../module/page';
import listMoreButtons from '../../module/listMoreButtons';
import listpage from '../../module/listpage';
import mixin from '../../utils/mixin';
import { removeHtml, fixImagePath } from '../../utils/utils';
import request from '../../config/request';

const goodsBtns = [{
  id: 'collect',
  label: '收藏',
  icon: 'icon-star'
},
{
  id: 'buy',
  label: '购买',
  icon: 'icon-basket'
}];

const GoodsMixin = mixin(listpage, [{
  components: {
    list: {
      component: list,
      options() {
        return {
          moreButtons: goodsBtns,
          customModifyItem(item) {
            item.section = {
              ID: 0,
              type: 'grid-card',
              class: 'padder-half bg-white b-t padder-t'
            };
            item.primaryText = item.__c61;
            item.url = fixImagePath(item.__c65);
            item.price = item.__c64;
          }
        };
      }
    },
    tab
  },
  methods: {
    moreButtonClicked(button, data) {
      const items = data ? [data] : this.coms.list.getSelectedItems();
      if (button.id === 'collect') {
        request.collectGoods(this, items);
      } else if (button.id === 'buy') {
        request.buyGoods(this, items);
      }
    }
  },
  extendModeButtons(button) {
    const buttons = listMoreButtons.extendModeButtons(this, button);
    buttons.push(...goodsBtns);
    return buttons;
  },
  onLoad() {
    const types = [
      {
        title: '热门',
        key: 'hot',
        lsc: { patternId: 71, pTypeId: 1, operation: 1, val1: true }
      },
      {
        title: '新品',
        key: 'new',
        lsc: { patternId: 72, pTypeId: 1, operation: 1, val1: true },
      },
      {
        title: '推荐',
        key: 'recommend',
        lsc: { patternId: 87, pTypeId: 1, operation: 1, val1: true },
      }
    ];
    this.coms.tab.setData({
      list: types,
      scroll: false
    });
    this.on('tabChanged', this.tabChanged);
  },
  tabChanged(scope, item, selected, toggle) {
    if (this.getChildEventScope(scope) === 'tab') {
      this.updatePageInfo(item);
      this.coms.list.refresh();
    }
  }
}]);

Page(getPage(GoodsMixin, {
  pageId: 41
}));
