import Component from '../../components/component';
import getPage from '../../module/page';
import { list } from '../../polaris/polaris';
import listMoreButtons from '../../module/listMoreButtons';
import listpage from '../../module/listpage';
import mixin from '../../utils/mixin';
import request from '../../config/request';

const goodsBtns = [{
      id: 'delete',
      label: '删除',
      icon: 'icon-trash'
    }];

const GoodsImportMixin = mixin(listpage, [{
  components: {
    list: {
      component: list,
      options() {
        return {
          methods:{
            handleMoreTap(e) {
              const item = this.getTapItem(e);
              this.emit('showFollow', this.page, { e, item }, goodsBtns);
            }
          }
        }
      }
    }
  },
  selectMode: 'check',
  hasGrid: true,
  methods: {
    moreButtonClicked(button, data) {
      const items = data ? [data] : this.coms.list.getSelectedItems();
      if (button.id === 'delete') {
        request.deleteImport(this, items);
      }
    }
  },
  extendModeButtons(button) {
    const buttons = listMoreButtons.extendModeButtons(this, button);
    buttons.push(...goodsBtns);
    return buttons;
  }
}]);

Page(getPage(GoodsImportMixin, {
  pageId: 135
}));
