import getPage from '../../module/page';
import { list } from '../../polaris/polaris';
import listpage from '../../module/listpage';
import mixin from '../../utils/mixin';
import { removeHtml } from '../../utils/utils';

const HelpMixin = mixin(listpage, [{
  components: {
    list: {
      component: list,
      options: {
        checkType: 'radio',
        deselectable: true,
        customModifyItem(item) {
          item.__c231 = removeHtml(item.__c231);
        }
      }
    }
  }
}]);

Page(getPage(HelpMixin, {
  pageId: 217
}));
