import { fixImagePath, formatDate, removeHtml } from '../../utils/utils';
import { list, tab } from '../../polaris/polaris';

import { dateStr } from '../../utils/dateUtils';
// import filterMixin from '../../module/filterMixin';
import getPage from '../../module/page';
import mixin from '../../utils/mixin';
import request from '../../config/request';
import signalr from '../../redux/signalr'
import viewpage from '../../module/viewpage';
import { login } from '../../redux/login';

import { cache2 , common } from '../../utils/request';

const SquareMixin = mixin(viewpage, [{
  components: {
    list: {
      component: list,
    },
    tab
  },
  fetchOnEnter: false,
   mustLogin: true,
  onReady(){

  //    this.handleLogin();
  },
  onShow(){
    cache2( 'cacheTime', '2013-01-01').then((ret)=>{
         getApp().cacheTime = ret.cachetime[0].cacheTime;
    });



     console.log('login');

  },
  renderSections( dataList ){
  const sections = [];


sections.push(
  {
    ID: 1,
    type: 'grid',
    itemClass: 'col-xs-4 m-b-sm padder-v white',
    class: 'm-b-sm  bg-main ',
    items: [
      {
        label: '+业务跟进',
        url: '/images/quick_sign_in.png',
        labelClass : 'm-t-sm text-base text-white',
        pageId: 339
      },
      {
        label: '+待办',
        url: '/images/abc_btn_rating_star_on_mtrl_alpha.png',
        labelClass : 'm-t-sm text-base text-white',
        pageId: 508,

      }
      ,
      {
        label: '+质检明细',
        url: '/images/abc_btn_rating_star_off_mtrl_alpha.png',
        labelClass : 'm-t-sm text-base text-white',
        pageId: 460,

      }
    ]
  });






    sections.push(
       {
         ID:3,
         type: 'grid',
         class: 'bg-white',
         columnCount: 4,
         itemClass: 'padder-v b-b  b-r',
         items: [
           {
             label: '客户',
             url: '/images/vv6.png',
             labelClass:'text-base m-t overflow-hidden',
             imageClass:'img-25-25 r-2x',
             pageId: 3,
           }
           ,
           {
             label: '供应商',
             url: '/images/vv3.png',
             labelClass:'text-base m-t overflow-hidden',
             imageClass:'img-25-25 r-2x',
             pageId: 411,
           },
           {
             label: '销售订单',
             url: '/images/vv2.png',
             labelClass:'text-base m-t overflow-hidden',
             imageClass:'img-25-25 r-2x',
             pageId: 'goods',
           }
           ,
           {
             label: '采购合同',
             url: '/images/tongxin.png',
             labelClass:'text-base m-t overflow-hidden',
             imageClass:'img-25-25 r-2x',
             pageId: 59,
           },
           {
             label: '产品库',
             url: '/images/vv5.png',
             labelClass:'text-base m-t overflow-hidden',
             imageClass:'img-25-25 r-2x',
             pageId: '28',
           }
           ,
           {
             label: '开票',
             url: '/images/tongxin.png',
             labelClass:'text-base m-t overflow-hidden',
             imageClass:'img-25-25 r-2x',
               pageId: 251,
           },
           {
             label: '应收款',
             url: '/images/vv1.png',
             labelClass:'text-base m-t overflow-hidden',
             imageClass:'img-25-25 r-2x',
             pageId: 290 ,
           },
           {
             label: '统计分析',
             url: '/images/tongji.png',
             labelClass:'text-base m-t overflow-hidden',
             imageClass:'img-25-25 r-2x',
                  pageId: 80000,

           },
           {
             label: '财务合同',
             url: '/images/vv3.png',
             labelClass:'text-base m-t overflow-hidden',
             imageClass:'img-25-25 r-2x',
             pageId: 243,
           }
           ,
           {
             label: '寄样单',
             url: '/images/vv4.png',
             labelClass:'text-base m-t overflow-hidden',
             imageClass:'img-25-25 r-2x',
             pageId: 379,
           },
           {
             label: '打样单',
             url: '/images/tongxin.png',
             labelClass:'text-base m-t overflow-hidden',
             imageClass:'img-25-25 r-2x',
             pageId: 395,
           },
           {
             label: '待办事项',
             url: '/images/vv5.png',
             labelClass:'text-base m-t overflow-hidden',
             imageClass:'img-25-25 r-2x',
             pageId: 510,
           }

        ]


  });




  sections.push({
      ID:4,
      type:'list-item',
      header:{
        class:'m-t-sm'
      },
      items: [
        {
          icon:'fa fa-th-large',
          iconClass:'text-sm text-gray',
          primaryText: '使用说明',
          primaryClass: 'text-md  ',
          pageId: 'note'
        }
      ],
    });



    if (dataList.length===0){
      dataList = [{_Key: "本月应收款", _Value: "0000",icon:'fa fa-star'},{_Key: "本月应付款", _Value: "0000",icon:'fa fa-bookmark-o'},
                  {_Key: "执行中订单", _Value: "0000",icon:'fa fa-bell-o'},{_Key: "总体业绩", _Value: "0000",icon:'fa fa-money'},
                  {_Key: "新增订单数", _Value: "0000",icon:'fa fa-laptop'},{_Key: "环比增幅", _Value: "0000",icon:'fa fa-cubes'},
                      ];
    }




    const dtl = JSON.stringify(dataList);
    if (dtl.length<3){
       dataList = [{_Key: "本月应收款", _Value: "0000",icon:'fa fa-star'},{_Key: "本月应付款", _Value: "0000",icon:'fa fa-bookmark-o'},
                  {_Key: "执行中订单", _Value: "0000",icon:'fa fa-bell-o'},{_Key: "总体业绩", _Value: "0000",icon:'fa fa-money'},
                  {_Key: "新增订单数", _Value: "0000",icon:'fa fa-laptop'},{_Key: "环比增幅", _Value: "0000",icon:'fa fa-cubes'},
                      ];
    }




    sections.push({
        ID:5,
        type:'grid-h',
        class:'bg-white padder-lg m-t-sm',
        columnCount: 2,
        items:  dataList.map(i => {   return {
            type: 'grid-h',
            class: 'padder-v-md padder',
            primaryText: i._Key,
            primaryClass: 'text-muted',
            icon: i.icon + ' primary-color text-lg',
            iconClass: '  padder-sm',
            imageContainer: 'b-r',
            secondaryText:  i._Value,
            secondaryClass: 'text-muted2'
          }

        })

      });





      this.coms.list.updateItems(sections);


},
  onLoad() {


    this.renderSections([]);

     common( { pageId : 50001, lscStr:[{'_Key':'__c20','_Value':3}] }).then((ret)=>{
        this.renderSections(ret.data);
     });






  }

}]);

Page(getPage(SquareMixin));
