import { formatDate, removeHtml, fixImagePath } from '../../utils/utils';

import getPage from '../../module/page';
import {filtab, list } from '../../polaris/polaris';
import listpage from '../../module/listpage';
import mixin from '../../utils/mixin';
import request from '../../config/request';

const MessageMixin = mixin(listpage, [{
  components: {
    filtab: {
                  component: filtab,
                  options() {
                      return {
                          refreshColumns: true
                      };
                  }
    },
    list: {
      component: list,
      options() {
        return {
          customModifyItem(item) {
            item.section = {
              ID: 0,
              type: 'list-item-n',
              itemClass: 'padder-t-sm ',
              class: 'padder-t-xxs  padder-b-sm'
            };
            Object.assign(item, {
                primaryText: `${removeHtml(item.__c746)}  `,
                primaryClass: 'flex text-l-3',
                secondaryText: `${item.__c750.statusName} `,
                secondaryClass: 'm-l-sm padder-v-xxs padder-xs r-3x bg-primary text-xs  text-muted',
                primaryText2: `时间 ： ${formatDate(item.__c748, 'yyyy-MM-dd hh:mm')} ` ,
                primaryClass2: `flex  text-muted    padder-xs r-3x  `,
                primaryText3: `业务单号 ： ${item.__c58} ` ,
                primaryClass3: `flex  text-muted    padder-xs r-3x  `,
                secondaryText3: `产品:${item.__c41} `,
                secondaryClass3: 'm-l-sm padder-v-xxs padder-xs r-3x  text-muted',





                pageId: 515,
            });
          }
        }
      }
    }
  }
}]);

Page(getPage(MessageMixin, {
  pageId: 510
}));
