import getPage from '../../module/page';
import mixin from '../../utils/mixin';
import { removeHtml, formatDate } from '../../utils/utils';
import request from '../../config/request';
import viewpage from '../../module/viewpage';

const ViewMessageMixin = mixin(viewpage, [{
  excludes: [41, 119, 120, 121, 123, 124, 125, 126, 127],
  updateButtons() {
    const item = this.getData().item;
    if (item.__c124 && item.__c124.ID) {
      if (item.__c124.ID === 599){
        return [{
          id: 'agree',
          label: '同意',
          icon: 'fa fa-mail-reply'
        },
        {
          id: 'ignore',
          label: '忽略',
          icon: 'icon-trash'
        }];
      }
      return [];
    }

    return [{
      id: 'reply',
      label: '回复',
      icon: 'fa fa-mail-reply'
    },
    {
      id: 'delete',
      label: '删除',
      icon: 'icon-trash'
    }];
  },
  methods: {
    moreButtonClicked(button) {
      if (button.id === 'delete') {
        const data = this.getData();
        request.deleteMessage(this, data.item, () => {
          wx.navigateBack();
        });
      } else if (button.id === 'reply') {
        const data = this.getData();
        let receiver = data.item.__c119;
        if (typeof receiver !== 'object') {
          this.emit('showToptip', this.page, { icon: 'warn', text: '对不起，该消息找不到发件人' });
          return;
        }
        this.navigateTo('/pages/message/editmessage', {
          item: {
            __c120: Object.assign({ ID: receiver.UserId, primaryText: receiver.XingMing }, receiver)
          }
        });
      } else if (button.id === 'agree') {
        const data = this.getData();
        request.agreeFriend(this, data.item, ()=>{
          wx.navigateBack();
        });
      } else if (button.id === 'ignore') {
        const data = this.getData();
        request.ignoreFriend(this, data.item, ()=>{
          wx.navigateBack();
        });
      }
    }
  },
  customModifyItem(item) {
    item.__c122 = removeHtml(item.__c122);
    item.__c123 = formatDate(item.__c123, 'yyyy-MM-dd hh:mm:ss');
  },
  updateRedux({ detailData }) {
    if (this.redux.detailData && this.detailData.data && this.detailData !== this.redux.detailData[this.getOption('pageId')]) {
      if (!this.marked) {
        request.markReaded(this, this.detailData.data);
        this.coms.footer.switchExtendMode(false);
        this.marked = true;
      }
    }
  }
}]);

Page(getPage(ViewMessageMixin, {
  pageId: 85,
  categoryId: 13
}));
