import { changePassword } from '../../utils/request';
import editpage from '../../module/editpage';
import getPage from '../../module/page';
import mixin from '../../utils/mixin';
import { refreshItemDisplay } from '../../utils/utils';

const ModifyPasswordMixin = mixin(editpage, [{
  onLoad(options) {
    this.filter = {
      display: [
        {
          ID: 'OldPassword',
          eid: 'OldPassword',
          required: true,
          editType: 'password',
          primaryText: '原密码',
          property: {
            placeholder: '请输入原密码'
          }
        },
        {
          ID: 'NewPassword',
          eid: 'NewPassword',
          required: true,
          editType: 'password',
          primaryText: '新密码',
          property: {
            placeholder: '请输入新密码'
          },
          equal: 'ConfirmPassword'
        },
        {
          ID: 'ConfirmPassword',
          eid: 'ConfirmPassword',
          required: true,
          editType: 'password',
          primaryText: '重复密码',
          property: {
            placeholder: '请再次输入新密码'
          }
        }
      ]
    };
    const item = {};
    refreshItemDisplay(this.filter.display, null, item, 'ord', true).then(()=>{
      this.setData({
        columns: this.filter.display,
        item
      });
    });
  },
  moreButtonClicked(button) {
    if (button.id === 'submit') {
      if (this.checkValid()) {
        const data = this.getData();
        this.runAsync(() => {
          return changePassword({
            OldPassword: data.item.OldPassword,
            NewPassword: data.item.NewPassword,
            ConfirmPassword: data.item.ConfirmPassword
          }).then(() => {
            wx.navigateBack();
          });
        });
      }
    }
    return true;
  }
}]);

Page(getPage(ModifyPasswordMixin));
