import { filtab, list } from '../../polaris/polaris';

import getPage from '../../module/page';
import listMoreButtons from '../../module/listMoreButtons';
import listpage from '../../module/listpage';
import mixin from '../../utils/mixin';
import request from '../../config/request';

const goodsBtns = [{
  id: 'delete',
  label: '删除',
  icon: 'icon-trash'
}];

const GoodsMixin = mixin(listpage, [{
  components: {
    list: {
      component: list,
      options() {
        return {
          methods: {
            handleMoreTap(e) {
              const item = this.getTapItem(e);
              this.emit('showFollow', this.page, { e, item }, goodsBtns);
            }
          }
        };
      }
    },
    filtab: {
      component: filtab,
      options() {
        return {
          hasMore: true
        };
      }
    }
  },
  selectMode: 'check',
  hasGrid: true,
  methods: {
    moreButtonClicked(button, data) {
      const items = data ? [data] : this.coms.list.getSelectedItems();
      if (button.id === 'delete') {
        request.deleteGoods(this, items);
      }
    }
  },
  handleTapEvent(scope, index, item) {
    if (this.getChildEventScope(scope) === 'list') {
      if (this.coms.list.checkType !== '') {
        return;
      }

      this.navigateTo('/pages/editgoods/index', {
        itemId: this.getItemId(item)
      });
    }
  },
  extendModeButtons(button) {
    const buttons = listMoreButtons.extendModeButtons(this, button);
    buttons.push(...goodsBtns);
    return buttons;
  },
  getItemId(item) {
    return item.__c22;
  }
}]);

Page(getPage(GoodsMixin, {
  pageId: 20
}));
